package com.bailuntec.ana.infrastructure.common.config.config;

import com.bailuntec.ana.vo.order.Currency;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/**
 * <p>
 * mybatis 全局currency转换器
 * </p>
 *
 * @author robbendev
 * @since 2020/8/5 9:36 上午
 */
@Component
public class CurrencyTypeHandler implements ApplicationContextAware {
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {

        //从spring容器获取sqlSessionFactory
        SqlSessionFactory sqlSessionFactory = applicationContext.getBean(SqlSessionFactory.class);
        //获取typeHandler注册器
        TypeHandlerRegistry typeHandlerRegistry = sqlSessionFactory.getConfiguration().getTypeHandlerRegistry();
        //注册Currency的typeHandler
        typeHandlerRegistry.register(Currency.class, JacksonTypeHandler.class);
    }
}
