package com.bailuntec.ana.infrastructure.common.base;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.AllArgsConstructor;
import lombok.Data;

/**
 * <p>
 * 统一返回结果
 * </p>
 *
 * @author robbendev
 * @since 2020/7/7 9:33 上午
 */
@JsonInclude()
@Data
@AllArgsConstructor
public class BaseResult<T> {
    public static final String CODE_SUCCESS = "200";
    public static final String CODE_ERROR = "500";


    // 返回信息-失败
    public static final String APP_DEFINE_ERR = "参数错误或者操作未成功";
    // 返回信息-成功
    public static final String APP_DEFINE_SUC = "操作成功";


    private String code;       //返回状态码
    private String message;   //返回信息
    private T data;          // 返回数据

    public BaseResult() {
        this.code = CODE_SUCCESS;
        this.message = APP_DEFINE_SUC;
    }


    public static <T> BaseResult<T> success() {
        return new BaseResult<>();
    }


    public static <T> BaseResult<T> success(T data) {
        return new BaseResult<>(CODE_SUCCESS, APP_DEFINE_SUC, data);
    }

    public static <T> BaseResult<T> error(String message) {
        return new BaseResult<>(CODE_ERROR, message, null);
    }

    public static <T> BaseResult<T> error(String code, String message) {
        return new BaseResult<>(code, message, null);
    }
}
