package com.bailuntec.ana.domain.order;

import com.bailuntec.ana.infrastructure.common.annotation.DictParam;
import com.bailuntec.ana.infrastructure.common.base.BaseModel;
import com.bailuntec.ana.interfaces.order.OrderValidGroup;
import com.bailuntec.ana.vo.order.Currency;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.URL;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "OrdeDetail", description = "")
@TableName(autoResultMap = true)
public class OrderDetail extends BaseModel {

    private static final long serialVersionUID = 1L;

    //未采购
    public static final Integer PURCHASE_STATUS_UN_PURCHASE = 1;
    //部分采购
    public static final Integer PURCHASE_STATUS_PURCHASING = 2;
    //采购失败
    public static final Integer PURCHASE_STATUS_FAILED = 3;
    //全部已采购
    public static final Integer PURCHASE_STATUS_SUCCESS = 4;

    //未发货
    public static final Integer DELIVERY_STATUS_UN_DELIVERY = 1;
    //已发货
    public static final Integer DELIVERY_STATUS_SUCCESS = 2;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "订单id")
    private String orderId;

    @NotNull(groups = OrderValidGroup.PublishOrder.class, message = "平台sku不能为空")
    @ApiModelProperty(value = "订单 平台sku编码")
    private String skuNo;

    @NotNull(groups = OrderValidGroup.PublishOrder.class, message = "平台itemId不能为空")
    @ApiModelProperty(value = "订单 平台spuId")
    private String itemId;

    @NotNull(groups = {OrderValidGroup.Purchase.class}, message = "采购item编号还未从刊登系统同步完成")
    @ApiModelProperty(value = "待采购 平台spuId 从刊登系统获取")
    private String purchaseAsin;

    @NotNull(groups = {OrderValidGroup.Purchase.class}, message = "采购sku编号还未从刊登系统同步完成")
    @ApiModelProperty(value = "待采购 平台sku编号 从刊登系统获取")
    private String purchaseSkuNo;

    @ApiModelProperty(value = "采购平台")
    private String purchasePlat;

    @Valid
    @NotNull(groups = OrderValidGroup.Purchase.class, message = "采购成本还未从刊登系统同步完成")
    @TableField(typeHandler = JacksonTypeHandler.class)
    @ApiModelProperty(value = "采购预计成本")
    private Currency costPrice;

    @NotNull(groups = OrderValidGroup.Purchase.class, message = "成本容忍范围为空")
    @Valid
    @TableField(typeHandler = JacksonTypeHandler.class)
    @ApiModelProperty(value = "容忍超过成本范围 超出不进行采购")
    private Currency tolerance;

    @NotNull(groups = OrderValidGroup.PublishOrder.class, message = "标题不能为空")
    @ApiModelProperty(value = "标题")
    private String title;

    @Min(value = 1, groups = {OrderValidGroup.PublishOrder.class, OrderValidGroup.Purchase.class}, message = "数量不能小于1")
    @NotNull(groups = {OrderValidGroup.PublishOrder.class, OrderValidGroup.Purchase.class}, message = "数量不能为空")
    @ApiModelProperty(value = "数量")
    private Integer quantity;

    @URL(groups = OrderValidGroup.PublishOrder.class, message = "销售sku源链接格式不正确")
    @ApiModelProperty(value = "销售sku源链接")
    private String originalLink;

    @DictParam(dictCode = "ORDER_DETAIL_PURCHASE_STATUS", dictValueParam = "purchaseStatusStr")
    @ApiModelProperty(value = "采购状态1-未采购 2-采购中 3-采购失败 4-采购完成")
    private Integer purchaseStatus;

    @TableField(exist = false)
    @ApiModelProperty(value = "采购状态1-未采购 2-采购中 3-采购失败 4-采购完成")
    private String purchaseStatusStr;

    private String purchaseMessage;

    @DictParam(dictCode = "ORDER_DETAIL_DELIVERY_STATUS", dictValueParam = "deliveryStatusStr")
    @ApiModelProperty("发货状态 1-未发货 2-已发货")
    private Integer deliveryStatus;

    @TableField(exist = false)
    @ApiModelProperty(value = "采购状态1-未采购 2-采购中 3-采购失败 4-采购完成")
    private String deliveryStatusStr;

    /**
     * <p>
     * 规格可以传空列表 不不能传空
     * </p>
     */
    @Valid
    @NotNull(groups = {OrderValidGroup.PublishOrder.class,
            OrderValidGroup.Purchase.class}, message = "规格不能为空")
    @TableField(exist = false)
    private List<OrderSpecification> orderSpecificationList;

}
