package com.bailuntec.ana.application.purchase;

import com.bailuntec.ana.domain.order.Order;
import com.bailuntec.ana.domain.purchase.PurchaseOrder;
import com.bailuntec.ana.vo.purchase.PmsCallBackResult;
import com.bailuntec.ana.vo.purchase.PurchaseCallBackRequest;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-08-01
 */
public interface IPurchaseOrderService extends IService<PurchaseOrder> {

    /**
     * <p>
     * 回调订单采购状态
     * </p>
     *
     * @param request callback
     */
    void callBackPurchaseOrder(PmsCallBackResult<PurchaseCallBackRequest> request);


    /**
     * <p>
     * 查询平台订单对应的所有采购订单
     * </p>
     *
     * @param orderId 平台订单
     * @return 采购订单
     */
    List<PurchaseOrder> listByOrderId(String orderId);


    /**
     * 回调oms订单采购信息
     *
     * @param order 订单详情
     */
    void callbackOms(Order order);
}
