package com.bailuntec.ana.application.order;

import com.bailuntec.ana.domain.order.Order;
import com.bailuntec.ana.domain.order.OrderDetail;
import com.bailuntec.ana.domain.purchase.PurchaseOrderDetail;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
public interface IOrderDetailService extends IService<OrderDetail> {

    /**
     * <p>
     * 根据订单id和订单和订单详情采购状态查询订单详情列表
     * </p>
     *
     * @param orderId        订单id
     * @param purchaseStatus 订单详情采购列表
     * @return 订单详情列表
     */
    List<OrderDetail> selectByOrderIdAndPurchaseStatus(String orderId, Integer purchaseStatus);


    /**
     * 聚合订单详情
     *
     * @param orderList 订单列表
     */
    void setOrderDetail(List<Order> orderList);

    /**
     * 聚合订单详情
     *
     * @param order 订单
     */
    void setOrderDetail(Order order);


    /**
     * <p>
     * 聚合订单详情
     * </p>
     *
     * @param purchaseOrderDetailList purchaseOrderDetailList
     */
    void setPurchaseOrderDetailOrderDetail(List<PurchaseOrderDetail> purchaseOrderDetailList);
}
