package com.bailuntec.ana.infrastructure.feign;

import com.bailuntec.ana.infrastructure.common.util.seq.IdWorker;
import com.bailuntec.ana.vo.order.Currency;
import com.bailuntec.ana.vo.product.resp.PdsSkuInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 刊登系统接口
 * </p>
 *
 * @author robbendev
 * @since 2020/8/4 4:13 下午
 */
@FeignClient(name = "PdsApi", url = "http://www.bailuntec.com/", fallback = PdsApi.PdsApiFallback.class)
public interface PdsApi {

    @GetMapping("/queryPdsSku")
    PdsSkuInfo queryPdsSku(@RequestParam String platform,
                           @RequestParam String sku);


    @Slf4j
    @Component
    class PdsApiFallback implements PdsApi {


        @Override
        public PdsSkuInfo queryPdsSku(String platform, String sku) {

            log.error("获取sku采购信息失败");

            PdsSkuInfo pdsSkuInfo = new PdsSkuInfo();
            pdsSkuInfo.setPlatform(platform);
            pdsSkuInfo.setSkuNo(sku);
            pdsSkuInfo.setPurchaseAsin(IdWorker.getId());
            pdsSkuInfo.setPurchasePlat("ebay");
            pdsSkuInfo.setPurchaseSkuNo(IdWorker.getId());
            pdsSkuInfo.setCostPrice(Currency.TEST);
            pdsSkuInfo.setTolerance(Currency.TEST);
            return pdsSkuInfo;
        }
    }
}
