package com.bailuntec.ana.infrastructure.feign;

import com.bailuntec.ana.vo.order.resp.OmsBaseResult;
import com.bailuntec.ana.vo.order.resp.PublishOrderCallBackRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * <p>
 * oms接口
 * </p>
 *
 * @author robbendev
 * @since 2020/7/31 2:10 下午
 */
@FeignClient(name = "OmsApi",url = "http://oms.bailuntec.com/")
public interface OmsApi {

    /**
     * <p>
     * oms推送订单到ana-order回调
     *
     * </p>
     *
     * @param request status=0:下单完成回调 status=1发货完成回调
     * @return result
     */
    @PostMapping("/apiV2/bailunOrder/updateOrderStatusForAna")
    OmsBaseResult<Void> updateOrderStatusForAna(@RequestBody PublishOrderCallBackRequest request);
}
