package com.bailuntec.ana.infrastructure.common.util;

import com.bailuntec.ana.infrastructure.common.exception.BizRuntimeException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;

import java.util.stream.Collectors;

/**
 * <p>
 * 异常工具类
 * </p>
 *
 * @author robbendev
 * @since 2020/8/3 4:24 下午
 */
public class ExceptionUtil {


    /**
     * <p>
     * 将springboot校验框架参数异常转换成业务异常
     * </p>
     *
     * @param ex springboot校验框架参数
     * @return result 业务异常
     */
    public BizRuntimeException handleMethodArgumentNotValidException(MethodArgumentNotValidException ex) {
        return new BizRuntimeException("INVALID_PARAMETER",
                ex.getBindingResult().getAllErrors().stream().map(ObjectError::getDefaultMessage).collect(Collectors.joining(",")));
    }
}
