package com.bailuntec.ana.domain.purchase;

import com.bailuntec.ana.infrastructure.common.base.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 采购任务
 * </p>
 *
 * @author robbendev
 * @since 2020-08-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "PurchaseTask对象", description = "")
public class PurchaseTask extends BaseModel {

    private static final long serialVersionUID = 1L;


    public static final Integer STATUS_EXECUTING = 1;
    public static final Integer STATUS_SUCCESS = 2;
    public static final Integer STATUS_FAILED = 3;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "ana-order id")
    private String orderId;

    private String taskType;

    @ApiModelProperty(value = "1-进行中 2-成功 3-失败")
    private Integer status;

    @ApiModelProperty(value = "任务信息")
    private String message;


}
