package com.bailuntec.ana.application.purchase.impl;

import com.bailuntec.ana.application.purchase.IPurchaseOrderDetailService;
import com.bailuntec.ana.domain.purchase.PurchaseOrder;
import com.bailuntec.ana.domain.purchase.PurchaseOrderDetail;
import com.bailuntec.ana.infrastructure.common.util.ListUtil;
import com.bailuntec.ana.infrastructure.mapper.purchase.PurchaseOrderDetailMapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-08-01
 */
@Service
public class PurchaseOrderDetailServiceImpl extends ServiceImpl<PurchaseOrderDetailMapper, PurchaseOrderDetail> implements IPurchaseOrderDetailService {


    @Override
    public void setPurchaseOrderDetail(List<PurchaseOrder> purchaseOrderList) {
        List<String> purchaseOrderIdList = purchaseOrderList.stream().map(PurchaseOrder::getId).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(purchaseOrderIdList)) {
            List<PurchaseOrderDetail> purchaseOrderDetailList = baseMapper.selectList(new LambdaQueryWrapper<PurchaseOrderDetail>()
                    .in(PurchaseOrderDetail::getPurchaseOrderId, purchaseOrderIdList));


            Map<String, List<PurchaseOrderDetail>> listMap = purchaseOrderDetailList.stream()
                    .collect(Collectors.groupingBy(PurchaseOrderDetail::getPurchaseOrderId));
            purchaseOrderList.forEach(purchaseOrder -> {
                purchaseOrder.setPurchaseOrderDetailList(listMap.get(purchaseOrder.getId()));
            });
        }
    }
}
