package com.bailuntec.ana.application.purchase;

import com.bailuntec.ana.domain.order.Order;
import com.bailuntec.ana.domain.purchase.PurchaseTask;
import com.bailuntec.ana.interfaces.order.OrderValidGroup;
import com.baomidou.mybatisplus.extension.service.IService;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-08-01
 */
@Validated
public interface IPurchaseTaskService extends IService<PurchaseTask> {


    /**
     * <p>
     * 下发采购任务
     * </p>
     *
     * @param order    平台订单详情
     * @param taskType 任务类型
     */
    @Validated(OrderValidGroup.Purchase.class)
    void addTask(@Valid Order order,
                 @NotNull(message = "任务类型不能为空") String taskType);

}
