package com.bailuntec.ana.application.order.impl;

import com.bailuntec.ana.application.order.IOrderDetailService;
import com.bailuntec.ana.application.order.IOrderSpecificationService;
import com.bailuntec.ana.domain.order.Order;
import com.bailuntec.ana.domain.order.OrderDetail;
import com.bailuntec.ana.domain.purchase.PurchaseOrderDetail;
import com.bailuntec.ana.infrastructure.common.util.ListUtil;
import com.bailuntec.ana.infrastructure.mapper.order.OrderDetailMapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
@Service
public class OrderDetailServiceImpl extends ServiceImpl<OrderDetailMapper, OrderDetail> implements IOrderDetailService {

    @Resource
    IOrderSpecificationService orderSpecificationService;

    @Override
    public List<OrderDetail> selectByOrderIdAndPurchaseStatus(String orderId, Integer purchaseStatus) {
        List<OrderDetail> orderDetailList = baseMapper.selectByOrderIdAndPurchaseStatus(orderId, purchaseStatus);
        orderSpecificationService.setOrderSpecification(orderDetailList);
        return orderDetailList;
    }


    @Override
    public void setOrderDetail(List<Order> orderList) {
        List<String> orderIdList = orderList.stream().map(Order::getId).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(orderIdList)) {
            List<OrderDetail> orderDetailList = this.list(new LambdaQueryWrapper<OrderDetail>()
                    .in(OrderDetail::getOrderId, orderIdList));

            orderSpecificationService.setOrderSpecification(orderDetailList);

            Map<String, List<OrderDetail>> orderDetailMap = orderDetailList.stream()
                    .collect(Collectors.groupingBy(OrderDetail::getOrderId));

            orderList.forEach(order -> order.setOrderDetailList(orderDetailMap.get(order.getId())));
        }
    }


    @Override
    public void setPurchaseOrderDetailOrderDetail(List<PurchaseOrderDetail> purchaseOrderDetailList) {
        List<String> orderDetailIdList = purchaseOrderDetailList.stream().map(PurchaseOrderDetail::getOrderDetailId).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(orderDetailIdList)) {
            List<OrderDetail> orderDetailList = this.listByIds(orderDetailIdList);

            orderSpecificationService.setOrderSpecification(orderDetailList);

            Map<String, OrderDetail> orderDetailMap = orderDetailList.stream()
                    .collect(Collectors.toMap(OrderDetail::getOrderId, orderDetail -> orderDetail, (k1, k2) -> k1));

            purchaseOrderDetailList.forEach(purchaseOrderDetail -> purchaseOrderDetail.setOrderDetail(orderDetailMap.get(purchaseOrderDetail.getOrderDetailId())));
        }
    }


    @Override
    public void setOrderDetail(Order order) {
        List<OrderDetail> orderDetailList = baseMapper.selectByOrderId(order.getId());
        orderSpecificationService.setOrderSpecification(orderDetailList);
    }

}
