package com.bailuntec.ana.vo.order.resp;

import com.bailuntec.ana.vo.order.Currency;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * oms推送订单回调参数
 * </p>
 *
 * @author robbendev
 * @since 2020/7/31 11:11 上午
 */
@Data
public class PublishOrderCallBackRequest {

    @JsonProperty("OriginalOrderNo")
    @ApiModelProperty("平台单号")
    private String originalOrderNo;

    @JsonProperty("PdsAccountId")
    @ApiModelProperty("平台帐号id")
    private String pdsAccountId;

    @ApiModelProperty("状态 0-已下单 1-已发货")
    private Integer status;

    @ApiModelProperty("物流跟踪号")
    private List<String> trackingNos;

    @ApiModelProperty("总实际采购成本")
    private Currency totalPrice;

    @ApiModelProperty("税")
    private Currency tax;
}
