package com.bailuntec.ana.infrastructure.schedule;

import com.bailuntec.ana.application.order.IOrderService;
import com.bailuntec.ana.domain.order.Order;
import com.bailuntec.ana.infrastructure.common.util.ListUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

@EnableScheduling
@AllArgsConstructor
@Slf4j
@Component
public class Schedule {

    @Resource
    IOrderService orderService;

    /**
     * <p>
     * 从pams同步订单里面的刊登帐号信息
     * </p>
     */
    @Scheduled(cron = "*/5 * * * * ?")
    public void syncOrderPdsAccount() {

        List<Order> orderList = orderService.queryUnSyncPdsAccountOrder();
        if (ListUtil.isNotEmpty(orderList)) {
            log.info("从pams同步订单里面的刊登帐号信息 任务开始");
            try {
                orderList.forEach(order -> orderService.syncOrderPdsAccount(order));
            } catch (Exception ex) {
                log.error("从pams同步订单里面的刊登帐号信息 任务失败,{}", ex.getMessage(), ex);
            }
            log.info("从pams同步订单里面的刊登帐号信息 任务完成");
        }
    }


    /**
     * <p>
     * 从刊登系统同步订单详情销售sku对应的采购item，采购sku，成本
     * </p>
     */
    @Scheduled(cron = "*/5 * * * * ?")
    public void syncOrderDetails() {
        List<Order> orderList = orderService.queryUnSyncDetailsOrder();
        if (ListUtil.isNotEmpty(orderList)) {
            log.info("从刊登系统同步订单详情销售sku对应的采购item，采购sku，成本 任务开始");
            try {
                orderList.forEach(order -> orderService.syncOrderDetails(order));
            } catch (Exception ex) {
                log.error("从刊登系统同步订单详情销售sku对应的采购item，采购sku，成本 任务失败,{}", ex.getMessage(), ex);
            }
            log.info("从刊登系统同步订单详情销售sku对应的采购item，采购sku，成本 任务完成");
        }
    }
}
