package com.bailuntec.ana.domain.order;

import com.bailuntec.ana.infrastructure.common.base.BaseModel;
import com.bailuntec.ana.interfaces.order.OrderValidGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;

/**
 * <p>
 * 订单平台sku规格
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "OrderSpecification对象", description = "订单平台sku规格")
public class OrderSpecification extends BaseModel {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "order_detail.id")
    private String orderDetailId;

    @NotNull(groups = {OrderValidGroup.PublishOrder.class,
            OrderValidGroup.Purchase.class}, message = "属性不能为空")
    @ApiModelProperty(value = "属性")
    @TableField(value = "`name`")
    private String name;

    @NotNull(groups = {OrderValidGroup.PublishOrder.class, OrderValidGroup.Purchase.class}, message = "属性值不能为空")
    @ApiModelProperty(value = "属性值")
    private String value;

}
