package com.bailuntec.ana.application.purchase.impl;

import com.bailuntec.ana.application.order.IOrderDetailService;
import com.bailuntec.ana.application.purchase.IPurchaseOrderService;
import com.bailuntec.ana.domain.order.OrderDetail;
import com.bailuntec.ana.domain.purchase.PurchaseOrder;
import com.bailuntec.ana.domain.purchase.PurchaseTask;
import com.bailuntec.ana.infrastructure.mapper.order.OrderDetailMapper;
import com.bailuntec.ana.infrastructure.mapper.purchase.PurchaseOrderMapper;
import com.bailuntec.ana.infrastructure.mapper.purchase.PurchaseTaskDetailMapper;
import com.bailuntec.ana.infrastructure.mapper.purchase.PurchaseTaskMapper;
import com.bailuntec.ana.vo.purchase.PmsCallBackResult;
import com.bailuntec.ana.vo.purchase.PurchaseCallBackRequest;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-08-01
 */
@Service
public class PurchaseOrderServiceImpl extends ServiceImpl<PurchaseOrderMapper, PurchaseOrder> implements IPurchaseOrderService {

    @Resource
    PurchaseTaskDetailMapper purchaseTaskDetailMapper;
    @Resource
    PurchaseTaskMapper purchaseTaskMapper;
    @Resource
    OrderDetailMapper orderDetailMapper;
    @Resource
    IOrderDetailService orderDetailService;

    @Override
    public void callBackPurchaseOrder(PmsCallBackResult<PurchaseCallBackRequest> request) {
        String purchaseTaskId = request.getId();

        List<OrderDetail> orderDetailList = orderDetailMapper.selectByTaskId(purchaseTaskId);
        PurchaseTask purchaseTask = purchaseTaskMapper.selectById(purchaseTaskId);

        if (!request.getData().getSuccess()) {
            purchaseTask.setStatus(PurchaseTask.STATUS_FAILED);
            purchaseTask.setMessage(request.getData().getMessage());
            purchaseTaskMapper.updateById(purchaseTask);

            orderDetailList.forEach(orderDetail -> {
                orderDetail.setPurchaseStatus(OrderDetail.PURCHASE_STATUS_FAILED);
                orderDetail.setPurchaseMessage(request.getData().getMessage());
                orderDetailMapper.updateById(orderDetail);
            });
        } else {
            purchaseTask.setStatus(PurchaseTask.STATUS_SUCCESS);
            purchaseTaskMapper.updateById(purchaseTask);

            orderDetailList.forEach(orderDetail -> {
                orderDetail.setPurchaseStatus(OrderDetail.PURCHASE_STATUS_SUCCESS);
                orderDetailMapper.updateById(orderDetail);
            });
            //todo 回调oms
        }
    }
}
