package com.bailuntec.ana.application.order.impl;

import com.bailuntec.ana.application.order.IOrderSpecificationService;
import com.bailuntec.ana.domain.order.OrderDetail;
import com.bailuntec.ana.domain.order.OrderSpecification;
import com.bailuntec.ana.infrastructure.common.util.ListUtil;
import com.bailuntec.ana.infrastructure.mapper.order.OrderSpecificationMapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-28
 */
@Service
public class OrderSpecificationServiceImpl extends ServiceImpl<OrderSpecificationMapper, OrderSpecification> implements IOrderSpecificationService {

    @Override
    public void setOrderSpecification(List<OrderDetail> orderDetailList) {
        List<String> orderDetailIdList = orderDetailList.stream().map(OrderDetail::getId).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(orderDetailIdList)) {
            Map<String, List<OrderSpecification>> orderSpecificationMap = baseMapper.selectList(new LambdaQueryWrapper<OrderSpecification>()
                    .in(OrderSpecification::getOrderDetailId, orderDetailIdList))
                    .stream()
                    .collect(Collectors.groupingBy(OrderSpecification::getOrderDetailId));
            orderDetailList.forEach(orderDetail -> orderDetail.setOrderSpecificationList(orderSpecificationMap.get(orderDetail.getId())));
        }
    }

    @Override
    public void setOrderSpecification(OrderDetail orderDetail) {
        Map<String, List<OrderSpecification>> orderSpecificationMap = baseMapper.selectList(new LambdaQueryWrapper<OrderSpecification>()
                .eq(OrderSpecification::getOrderDetailId, orderDetail.getId()))
                .stream()
                .collect(Collectors.groupingBy(OrderSpecification::getOrderDetailId));
        orderDetail.setOrderSpecificationList(orderSpecificationMap.get(orderDetail.getId()));
    }
}
