package com.bailuntec.serviceImpl;

import com.bailuntec.domain.pojo.DcDailySalesVO;
import com.bailuntec.mapper.DcDailySalesMapper;
import com.bailuntec.service.SalesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.util.StringUtil;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
@Service
public class SalesServiceImpl implements SalesService {
    @Autowired
    private DcDailySalesMapper dailySalesMapper;

    @Override
    public List<DcDailySalesVO> listSkus(String skus) {
        List<DcDailySalesVO> dcBaseSkus = new ArrayList<>();
        if (StringUtil.isNotEmpty(skus)) {
            String[] split = skus.split(",");
            for (String s : split) {
                DcDailySalesVO dcDailySalesVO = dailySalesMapper.listSkuInfo(s);
                if(dcDailySalesVO == null) {
                    dcDailySalesVO = new DcDailySalesVO(s,0,0,0,0,0, LocalDate.now().minusDays(1));
                }
                dcBaseSkus.add(dcDailySalesVO);
            }
        }
        return dcBaseSkus;
    }
}
