package com.bailuntec.domain;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class CostDto {
    private Integer id; // 费用单表 id
    private String costNo; // 费用单编号
    private String costPlanNo; // 费用计划编号
    private String companyNo; // 主体编号
    private String companyName; // 主体名称
    private String typeNo; // 大类编号
    private String typeName; // 大类标题
    private String kindNo; // 小类编号
    private String kindName; // 小类标题
    private Integer createUserid; // 创建人 id
    private String createUsercode; // 创建人编号
    private String createUsername; // 创建人名称
    private String costRemark; // 费用单备注
    private Date createTime; // 创建时间
    private String sonCostNo; // 关联子单
    private String supCostNo; // 关联父单
    private Integer costStatus; // 费用单状态 0 未提交 1待审核 2待出纳付款 3已支付
    private String costStatusDto; // 费用单状态 0 未提交 1待审核 2待出纳付款 3已支付
    private String filePath; // 文件地址
    private String fileName; // 文件名
    private String morFilePath; // 补充材料地址
    private String morFileName; // 补充材料文件名
    private BigDecimal amount; // 费用总金额
    private String amountDto;
    private Integer subLogisticsSupplierId; // 二级物流供应商ID
    private Integer logisticsSupplierId; // 一级物流供应商ID
    private String bankName; // 收款银行（平台）
    private String bankCard; // 收款账户
    private String bankCardUser; // 收款用户名
    private String bankCompany; // 收款/付款单位
    private String morRemark; // 补充信息
    private Integer isLend; // 0 普通费用  1 借支  2 借还
    private String isLendDto;// 0 普通费用  1 借支  2 借还
    private Integer costForm; // 费用类型
    private String costFormDto; // 费用类型
    private String costReason; // 付款理由
    private BigDecimal hadPay; // 借支单已还金额
    private Integer lendStatus; // 借支单状态 1 未还 2 部分还款  3 结清
    private String lendStatusDto;
    private BigDecimal compensate; // 借支单补偿金额
    private BigDecimal counteract; // 冲销金额
    private BigDecimal lendBalance; // 借还单余额
    private String rejectReason; // 驳回原因
    private String dic; // 币种
    private String dicDto; // 币种
    private BigDecimal payCounteract; // 借还单冲销金额 ( 支付币种 )
    private BigDecimal payLendBalance; // 借还单余额 （ 支付币种 ）
    private BigDecimal payPlanAmount; // 计划金额 （ 支付币种 ）
    private String payPlanAmountDto;
    private String payDic; // 支付币种
    private String payDicDto; // 支付币种
    private BigDecimal payCur; // 汇率
    private Integer isTax; // 0 不抵扣个税  1 抵扣个税
    private String isTaxStr; // 0 不抵扣个税  1 抵扣个税
    private String detailKey; // 出纳系统 detailKey
    private Date payTime; // 付款时间

    @Override
    public String toString() {
        return "CostDto{" +
                "id=" + id +
                ", costNo='" + costNo + '\'' +
                ", costPlanNo='" + costPlanNo + '\'' +
                ", companyNo='" + companyNo + '\'' +
                ", companyName='" + companyName + '\'' +
                ", typeNo='" + typeNo + '\'' +
                ", typeName='" + typeName + '\'' +
                ", kindNo='" + kindNo + '\'' +
                ", kindName='" + kindName + '\'' +
                ", createUserid=" + createUserid +
                ", createUsercode='" + createUsercode + '\'' +
                ", createUsername='" + createUsername + '\'' +
                ", costRemark='" + costRemark + '\'' +
                ", createTime=" + createTime +
                ", sonCostNo='" + sonCostNo + '\'' +
                ", supCostNo='" + supCostNo + '\'' +
                ", costStatus=" + costStatus +
                ", costStatusDto='" + costStatusDto + '\'' +
                ", filePath='" + filePath + '\'' +
                ", fileName='" + fileName + '\'' +
                ", morFilePath='" + morFilePath + '\'' +
                ", morFileName='" + morFileName + '\'' +
                ", amount=" + amount +
                ", amountDto='" + amountDto + '\'' +
                ", logisticsSupplierId=" + logisticsSupplierId +
                ", subLogisticsSupplierId=" + subLogisticsSupplierId +
                ", bankName='" + bankName + '\'' +
                ", bankCard='" + bankCard + '\'' +
                ", bankCardUser='" + bankCardUser + '\'' +
                ", bankCompany='" + bankCompany + '\'' +
                ", morRemark='" + morRemark + '\'' +
                ", isLend=" + isLend +
                ", isLendDto='" + isLendDto + '\'' +
                ", costForm=" + costForm +
                ", costFormDto='" + costFormDto + '\'' +
                ", costReason='" + costReason + '\'' +
                ", hadPay=" + hadPay +
                ", lendStatus=" + lendStatus +
                ", lendStatusDto='" + lendStatusDto + '\'' +
                ", compensate=" + compensate +
                ", counteract=" + counteract +
                ", lendBalance=" + lendBalance +
                ", rejectReason='" + rejectReason + '\'' +
                ", dic='" + dic + '\'' +
                ", dicDto='" + dicDto + '\'' +
                ", payCounteract=" + payCounteract +
                ", payLendBalance=" + payLendBalance +
                ", payPlanAmount=" + payPlanAmount +
                ", payPlanAmountDto='" + payPlanAmountDto + '\'' +
                ", payDic='" + payDic + '\'' +
                ", payDicDto='" + payDicDto + '\'' +
                ", payCur=" + payCur +
                ", isTax=" + isTax +
                ", isTaxStr='" + isTaxStr + '\'' +
                ", detailKey='" + detailKey + '\'' +
                ", payTime=" + payTime +
                '}';
    }
}
