package com.bailuntec.job;

import com.bailuntec.domain.constant.CommonConstant;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.pojo.CommonSkuCondition;
import com.bailuntec.support.PointJob;
import com.dangdang.ddframe.job.api.ShardingContext;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class SkuSyncByCreateTimeJob extends PointJob {

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
        //SKUMS接口需要的请求参数
        CommonSkuCondition skuConditionDto = new CommonSkuCondition();
        skuConditionDto.setResultType(2);//分页
        skuConditionDto.setPageSize(jobPointLog.getPageSize());
        skuConditionDto.setStatus(-1);
        //传这个所有上传状态都能拿
        skuConditionDto.setIsUpApi("");
        skuConditionDto.setIsFinish(-1);
        //有ResultWare返回发货仓库信息
        skuConditionDto.setIsResultWare(1);
        //有UpdateDate只查当天更新的数据-增量更新
        skuConditionDto.setBeginCT(jobPointLog.getStartTime().minusMinutes(10).format(DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT)));
        jobPointLog.setEndTime(LocalDateTime.now());
        skuConditionDto.setEndCT(jobPointLog.getEndTime().format(DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT)));
        SkuJsonHandle.skuMSRequest(skuConditionDto, jobPointLog);
    }



}
