package com.bailuntec.job;

import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.pojo.CommonSkuCondition;
import com.bailuntec.support.PointJob;
import com.dangdang.ddframe.job.api.ShardingContext;

public class SkuSyncJob extends PointJob {

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
        //SKUMS接口需要的请求参数
        CommonSkuCondition skuConditionDto = new CommonSkuCondition();
        skuConditionDto.setResultType(2);//分页
        skuConditionDto.setPageSize(jobPointLog.getPageSize());
        skuConditionDto.setStatus(-1);
        skuConditionDto.setIsFinish(-1);
        //有ResultWare返回发货仓库信息
        skuConditionDto.setIsResultWare(1);
        //有SKU只查提供的SKU
//        skuConditionDto.setSkus("909117825");
        //有UpdateDate只查当天更新的数据-增量更新
//        skuConditionDto.setUpdateDate(jobPointLog.getStartTime().format(DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT)));
        SkuJsonHandle.skuMSRequest(skuConditionDto, jobPointLog);
    }


}
