package com.bailuntec.job;

import com.bailuntec.domain.dto.DcBaseFinanceEbayItemDto;
import com.bailuntec.domain.dto.DcBaseSkuMappingItemDto;
import com.bailuntec.domain.entity.*;
import com.bailuntec.domain.example.DcBaseFinanceEbayExample;
import com.bailuntec.mapper.DcBaseFinanceEbayItemMapper;
import com.bailuntec.mapper.DcBaseFinanceEbayMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.List;

@Slf4j
public class CalculateEbayItemJob extends PointJob {

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
        long countEbayFee;
        try{
            DcBaseFinanceEbayMapper dcBaseFinanceEbayMapper = SessionUtil.getSession().getMapper(DcBaseFinanceEbayMapper.class);
            countEbayFee = dcBaseFinanceEbayMapper.countByExample(DcBaseFinanceEbayExample.newAndCreateCriteria().andBjDateGreaterThanOrEqualTo(jobPointLog.getStartTime()).andBjDateLessThan(jobPointLog.getEndTime()).example());
        }catch (Exception e){
            e.printStackTrace();
            throw new RuntimeException("MYBATIS操作DB失败", e);
        }finally {
            SessionUtil.closeSession();
        }

        long totalPage = getEbayPage(countEbayFee, jobPointLog);

        do{
            List<DcBaseFinanceEbayItemDto> dcBaseFinanceEbayItemDtoList;
            try{
                DcBaseFinanceEbayMapper dcBaseFinanceEbayMapper = SessionUtil.getSession().getMapper(DcBaseFinanceEbayMapper.class);
                dcBaseFinanceEbayItemDtoList = dcBaseFinanceEbayMapper.selectEbayList(jobPointLog);
                for(DcBaseFinanceEbayItemDto dcBaseFinanceEbayItemDto : dcBaseFinanceEbayItemDtoList) {

                    if(dcBaseFinanceEbayItemDto.getDcBaseSkuMappingList() != null && dcBaseFinanceEbayItemDto.getDcBaseSkuMappingList().size() > 0) {
                        BigDecimal totalUnitPrice = getTotalUnitPrice(dcBaseFinanceEbayItemDto.getDcBaseSkuMappingList());
                        for(DcBaseSkuMappingItemDto dcBaseSkuMappingItemDto : dcBaseFinanceEbayItemDto.getDcBaseSkuMappingList()) {
                            DcBaseFinanceEbayItem dcBaseFinanceEbayItem = new DcBaseFinanceEbayItem();
                            BeanUtils.copyProperties(dcBaseFinanceEbayItem, dcBaseSkuMappingItemDto);
                            BigDecimal unitPrice = dcBaseSkuMappingItemDto.getUnitPrice() == null ? BigDecimal.ZERO : dcBaseSkuMappingItemDto.getUnitPrice();
                            BigDecimal unitPriceRadio;
                            if(totalUnitPrice.compareTo(BigDecimal.ZERO) == 0) {
                                unitPriceRadio = BigDecimal.ONE.divide(BigDecimal.valueOf(dcBaseFinanceEbayItemDto.getDcBaseSkuMappingList().size()), 3, RoundingMode.HALF_EVEN);
                            }else {
                                unitPriceRadio = unitPrice.multiply(BigDecimal.valueOf(dcBaseSkuMappingItemDto.getCount())).divide(totalUnitPrice, 3, RoundingMode.HALF_EVEN);
                            }
                            dcBaseFinanceEbayItem.setSkuRatio(unitPriceRadio);
                            dcBaseFinanceEbayItem.setSkuAmount(dcBaseFinanceEbayItemDto.getGrossAmount().multiply(unitPriceRadio));
                            dcBaseFinanceEbayItem.setAccountId(dcBaseFinanceEbayItemDto.getAccountId());
                            dcBaseFinanceEbayItem.setGrossAmount(dcBaseFinanceEbayItemDto.getGrossAmount());
                            dcBaseFinanceEbayItem.setAccountEntryType(dcBaseFinanceEbayItemDto.getAccountEntryType());
                            dcBaseFinanceEbayItem.setBjDate(dcBaseFinanceEbayItemDto.getBjDate());
                            dcBaseFinanceEbayItem.setGmtDate(dcBaseFinanceEbayItemDto.getGmtDate());
                            dcBaseFinanceEbayItem.setItemId(dcBaseFinanceEbayItemDto.getItemId());
                            dcBaseFinanceEbayItem.setEbayId(dcBaseFinanceEbayItemDto.getId());
                            dcBaseFinanceEbayItem.setCurrency(dcBaseFinanceEbayItemDto.getCurrency());
                            dcBaseFinanceEbayItem.setExchangeRate(dcBaseFinanceEbayItemDto.getExchangeRate());
                            dcBaseFinanceEbayItem.setExchangeRateUsd(dcBaseFinanceEbayItemDto.getExchangeRateUsd());
                            dcBaseFinanceEbayItem.setSkuCount(dcBaseSkuMappingItemDto.getCount());
                            if(dcBaseFinanceEbayItem.getBailunSku() == null) {
                                dcBaseFinanceEbayItem.setBailunSku("无");
                            }
                            DcBaseFinanceEbayItemMapper dcBaseFinanceEbayItemMapper = SessionUtil.getSession().getMapper(DcBaseFinanceEbayItemMapper.class);
                            dcBaseFinanceEbayItemMapper.insertSelective(dcBaseFinanceEbayItem);
                        }
                    }else{
                        DcBaseFinanceEbayItem dcBaseFinanceEbayItem = new DcBaseFinanceEbayItem();
                        dcBaseFinanceEbayItem.setSkuAmount(BigDecimal.ZERO);
                        dcBaseFinanceEbayItem.setAccountId(dcBaseFinanceEbayItemDto.getAccountId());
                        dcBaseFinanceEbayItem.setGrossAmount(dcBaseFinanceEbayItemDto.getGrossAmount());
                        dcBaseFinanceEbayItem.setAccountEntryType(dcBaseFinanceEbayItemDto.getAccountEntryType());
                        dcBaseFinanceEbayItem.setBjDate(dcBaseFinanceEbayItemDto.getBjDate());
                        dcBaseFinanceEbayItem.setGmtDate(dcBaseFinanceEbayItemDto.getGmtDate());
                        dcBaseFinanceEbayItem.setItemId(dcBaseFinanceEbayItemDto.getItemId());
                        dcBaseFinanceEbayItem.setEbayId(dcBaseFinanceEbayItemDto.getId());
                        dcBaseFinanceEbayItem.setCurrency(dcBaseFinanceEbayItemDto.getCurrency());
                        dcBaseFinanceEbayItem.setExchangeRate(dcBaseFinanceEbayItemDto.getExchangeRate());
                        dcBaseFinanceEbayItem.setExchangeRateUsd(dcBaseFinanceEbayItemDto.getExchangeRateUsd());
                        DcBaseFinanceEbayItemMapper dcBaseFinanceEbayItemMapper = SessionUtil.getSession().getMapper(DcBaseFinanceEbayItemMapper.class);
                        dcBaseFinanceEbayItemMapper.insertSelective(dcBaseFinanceEbayItem);
                    }

                }
            }catch (Exception e){
                e.printStackTrace();
                throw new RuntimeException("MYBATIS操作DB失败", e);
            }finally {
                SessionUtil.closeSession();
            }
            jobPointLog.setPageIndex(jobPointLog.getPageIndex()+1);
        }while (jobPointLog.getPageIndex() <= totalPage);
        jobPointLog.setPageIndex(0);
        jobPointLog.setStartTime(jobPointLog.getEndTime());
        jobPointLog.setEndTime(jobPointLog.getStartTime().plusDays(jobPointLog.getIntervalTime().longValue()).isAfter(LocalDateTime.now()) ? LocalDateTime.now() : jobPointLog.getStartTime().plusDays(jobPointLog.getIntervalTime().longValue()));
    }


    public long getEbayPage(long countEbayFee, JobPointLog jobPointLog) {

        if (countEbayFee % jobPointLog.getPageSize() == 0) {
            return countEbayFee / jobPointLog.getPageSize();
        }
        return countEbayFee / jobPointLog.getPageSize() + 1;
    }

    BigDecimal getTotalUnitPrice(List<DcBaseSkuMappingItemDto> dcBaseSkuMappingList) {
        BigDecimal totalUnitPrice = BigDecimal.ZERO;
        for(DcBaseSkuMappingItemDto dcBaseSkuMappingItemDto : dcBaseSkuMappingList) {
            BigDecimal unitPrice = dcBaseSkuMappingItemDto.getUnitPrice() == null ? BigDecimal.ZERO : dcBaseSkuMappingItemDto.getUnitPrice();
            totalUnitPrice = totalUnitPrice.add(unitPrice.multiply(BigDecimal.valueOf(dcBaseSkuMappingItemDto.getCount())));
        }
        return totalUnitPrice;
    }
}
