package com.bailuntec.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bailuntec.domain.constant.CommonConstant;
import com.bailuntec.domain.entity.DcBaseFinanceInterest;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.DcBaseFinanceInterestExample;
import com.bailuntec.mapper.DcBaseFinanceInterestMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.PropertiesUtil;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;

@Slf4j
public class InterestJob extends PointJob {

    private OkHttpClient okHttpClient = OkHttpUtil.getInstance();
    private PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("const");

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
        LinkedHashMap<String, String> map = new LinkedHashMap<>(4);
        map.put("startDate", DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT).format(jobPointLog.getStartTime()));
        map.put("endDate", DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT).format(jobPointLog.getEndTime()));

            Response response = null;
            String palResultStr = null;
            try {
                Request request = new Request.Builder()
                        .get()
                        .url(OkHttpUtil.attachHttpGetParams(propertiesUtil.getPropertyAsString("INTEREST_URL"), map))
                        .addHeader("Content-Type", "application/json")
                        .build();
                response = okHttpClient.newCall(request).execute();
                palResultStr = response.body().string();
            } catch (IOException e) {
                throw new RuntimeException(map + "请求利息支出接口同步百伦接口失败" + response, e);
            } finally {
                if (response != null) {
                    response.close();
                }
            }
            if (StringUtils.isNoneBlank(palResultStr)) {
                List<DcBaseFinanceInterest> dcBaseFinanceInterestList = JSON.parseObject(palResultStr, new TypeReference<List<DcBaseFinanceInterest>>(){});
                if (dcBaseFinanceInterestList != null && dcBaseFinanceInterestList.size() > 0) {
                    DcBaseFinanceInterestMapper dcBaseFinanceInterestMapper = SessionUtil.getSession().getMapper(DcBaseFinanceInterestMapper.class);
                    dcBaseFinanceInterestMapper.deleteByExample(DcBaseFinanceInterestExample.newAndCreateCriteria().andActualRepayTimeBetween(LocalDateTime.of(jobPointLog.getStartTime().toLocalDate(), LocalTime.MIN), LocalDateTime.of(jobPointLog.getEndTime().toLocalDate(), LocalTime.MIN)).example());
                    for(DcBaseFinanceInterest dcBaseFinanceInterest : dcBaseFinanceInterestList) {
                        try {
                            dcBaseFinanceInterestMapper = SessionUtil.getSession().getMapper(DcBaseFinanceInterestMapper.class);
                            dcBaseFinanceInterestMapper.insertSelective(dcBaseFinanceInterest);
                        } catch (Exception e) {
                            log.warn("Mybatis 操作失败!", e);
                            throw new RuntimeException("MyBatis 操作失败!");
                        }finally {
                            SessionUtil.closeSession();
                        }
                    }
                }
            } else {
                throw new RuntimeException("调用利息支出接口同步百伦流水失败, 响应为null, 请求参数" + map.toString());
            }
        jobPointLog.setPageIndex(0);
        jobPointLog.setStartTime(jobPointLog.getEndTime());
        jobPointLog.setEndTime(jobPointLog.getEndTime().plusDays(jobPointLog.getIntervalTime()).isAfter(LocalDateTime.now()) ? LocalDateTime.now() : jobPointLog.getEndTime().plusDays(jobPointLog.getIntervalTime()));

    }
}
