package com.bailuntec.job;


import com.bailuntec.domain.constant.CommonConstant;
import com.bailuntec.domain.entity.DcAutoTurnover;
import com.bailuntec.domain.entity.DcBaseStock;
import com.bailuntec.domain.example.DcBaseStockExample;
import com.bailuntec.mapper.DcAutoSalesForecastStageConfigMapper;
import com.bailuntec.mapper.DcBaseStockMapper;
import com.bailuntec.utils.SessionUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSession;
import org.junit.jupiter.api.Test;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/25 4:43 下午
 */
@Slf4j
public class AutoTurnoverJobTest {


    @Test
    public void syncPartAutoTurnover() {

        AutoTurnoverJob autoTurnoverJob = new AutoTurnoverJob();

        try (SqlSession sqlSession = SessionUtil.getFactory().openSession(true)) {

            DcAutoSalesForecastStageConfigMapper dcAutoSalesForecastStageConfigMapper = sqlSession.getMapper(DcAutoSalesForecastStageConfigMapper.class);
            DcBaseStockMapper dcBaseStockMapper = sqlSession.getMapper(DcBaseStockMapper.class);

            List<DcAutoTurnover> dcAutoTurnoverList = dcAutoSalesForecastStageConfigMapper.selectTestSyncAutoTurnoverList();

            dcAutoTurnoverList.stream().parallel().forEach(dcAutoTurnover -> {

                DcBaseStock dcBaseStock = dcBaseStockMapper.selectOneByExample(DcBaseStockExample.newAndCreateCriteria()
                        .andBailunSkuEqualTo(dcAutoTurnover.getBailunSku())
                        .andWarehouseCodeEqualTo(dcAutoTurnover.getWarehouseCode())
                        .example());

                try {
                    if (dcBaseStock != null) {
                        log.info("计算周转开始 bailunSku:{} , warehouseCode:{}", dcBaseStock.getBailunSku(), dcBaseStock.getWarehouseCode());
                        autoTurnoverJob.autoTurnoverFromStock(DateTimeFormatter.ofPattern(CommonConstant.DATE_FORMAT).format(LocalDate.now()), dcBaseStock);
                        log.info("计算周转结束 bailunSku:{} , warehouseCode:{}", dcBaseStock.getBailunSku(), dcBaseStock.getWarehouseCode());
                    } else {
                        log.error("没有找到周转对应的baseStock");
                    }
                } catch (Exception e) {
                    log.error("计算周转失败 :{}", e.getMessage(), e);
                }
            });
        }

    }
}
