package com.bailuntec;

import com.alibaba.druid.pool.DruidDataSource;
import com.bailuntec.job.AutoTurnoverJob;
import com.bailuntec.listener.AutoTurnoverJobListener;
import com.bailuntec.utils.PropertiesUtil;
import com.dangdang.ddframe.job.config.JobCoreConfiguration;
import com.dangdang.ddframe.job.config.simple.SimpleJobConfiguration;
import com.dangdang.ddframe.job.event.JobEventConfiguration;
import com.dangdang.ddframe.job.event.rdb.JobEventRdbConfiguration;
import com.dangdang.ddframe.job.lite.api.JobScheduler;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperConfiguration;
import com.dangdang.ddframe.job.reg.zookeeper.ZookeeperRegistryCenter;
import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;

import javax.sql.DataSource;

@Slf4j
@MapperScan("com.bailuntec.mapper")
public class Application {
    private static PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("job");
    private static final String EVENT_RDB_STORAGE_DRIVER = propertiesUtil.getPropertyAsString("EVENT_RDB_STORAGE_DRIVER");
    private static final String EVENT_RDB_STORAGE_URL = propertiesUtil.getPropertyAsString("EVENT_RDB_STORAGE_URL");
    private static final String EVENT_RDB_STORAGE_USERNAME = propertiesUtil.getPropertyAsString("EVENT_RDB_STORAGE_USERNAME");
    private static final String EVENT_RDB_STORAGE_PASSWORD = propertiesUtil.getPropertyAsString("EVENT_RDB_STORAGE_PASSWORD");

    public static void main(String[] args) {

        log.info("starting app...");
//
        new JobScheduler(createRegistryCenter(),
                createJobConfigurationNormal(),
                createJobEventConfiguration(),
                new AutoTurnoverJobListener()).init();
        new JobScheduler(createRegistryCenter(),
                createJobConfigurationIncrement(),
                createJobEventConfiguration(),
                new AutoTurnoverJobListener()).init();

        log.info("start success");

    }

    private static CoordinatorRegistryCenter createRegistryCenter() {
        CoordinatorRegistryCenter regCenter = new ZookeeperRegistryCenter(new ZookeeperConfiguration(propertiesUtil.getPropertyAsString("ZOOKEEPER_SERVER"), propertiesUtil.getPropertyAsString("NAME_SPACE")));
        regCenter.init();
        return regCenter;
    }

    //
    private static LiteJobConfiguration createJobConfigurationNormal() {
        JobCoreConfiguration simpleCoreConfig = JobCoreConfiguration.newBuilder(
                propertiesUtil.getPropertyAsString("JOB_NAME"),
                propertiesUtil.getPropertyAsString("JOB_CRON"),
                propertiesUtil.getPropertyAsInt("SHARDING_TOTAL_COUNT"))
                .jobParameter("NORMAL")
                .build();
        SimpleJobConfiguration simpleJobConfig = new SimpleJobConfiguration(simpleCoreConfig, AutoTurnoverJob.class.getCanonicalName());
        return LiteJobConfiguration.newBuilder(simpleJobConfig).build();
    }

    private static LiteJobConfiguration createJobConfigurationIncrement() {
        JobCoreConfiguration simpleCoreConfig = JobCoreConfiguration.newBuilder(
                propertiesUtil.getPropertyAsString("JOB_NAME_INCREMENT"),
                propertiesUtil.getPropertyAsString("JOB_CRON_INCREMENT"),
                propertiesUtil.getPropertyAsInt("SHARDING_TOTAL_COUNT_INCREMENT"))
                .jobParameter("INCREMENT")
                .build();
        SimpleJobConfiguration simpleJobConfig = new SimpleJobConfiguration(simpleCoreConfig, AutoTurnoverJob.class.getCanonicalName());
        return LiteJobConfiguration.newBuilder(simpleJobConfig).build();
    }


    private static JobEventConfiguration createJobEventConfiguration() {
        return new JobEventRdbConfiguration(setUpEventTraceDataSource());
    }

    private static DataSource setUpEventTraceDataSource() {
        DruidDataSource result = new DruidDataSource();
        result.setDriverClassName(EVENT_RDB_STORAGE_DRIVER);
        result.setUrl(EVENT_RDB_STORAGE_URL);
        result.setUsername(EVENT_RDB_STORAGE_USERNAME);
        result.setPassword(EVENT_RDB_STORAGE_PASSWORD);
        return result;
    }

}
