package com.bailuntec.domain.entity;

import javax.persistence.*;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Table(name = "dc_base_sku", schema = "bailun_datacenter")
public class DcBaseSku {
    private Integer id;
    private String bailunSku;
    private String skuImage;
    private Integer categoryId;
    private String categoryName;
    private String warehouseCode;
    private String warehouseName;
    private BigDecimal unitPrice;
    private Integer sellerId;
    private String sellerName;
    private BigDecimal length;
    private BigDecimal width;
    private BigDecimal height;
    private BigDecimal weight;
    private Integer moq;
    private String skuTitleCn;
    private String skuTitleEn;
    private LocalDateTime createTime;
    private LocalDateTime updateTime;
    private LocalDateTime gmtCreate;
    private LocalDateTime gmtModified;
    private Integer suppliersId;
    private String suppliersName;
    private Integer supplierDelivery;
    private String currency;
    private String buyerName;
    private Integer buyerId;
    private Integer internalMoq;
    private Integer bussinessId;
    private String bussinessName;
    private Byte status;
    private Byte type;
    private String productCode;
    private String bailunInnerSku;
    private String productInnerCode;
    private Integer skumsId;
    private String suppliersLink;
    private Integer bailunCategoryId;
    private String bailunCategoryName;
    private String color;
    private String specifications;
    private String createName;
    private String updateName;
    private BigDecimal virtualPrice;
    private String sizeImage;
    private BigDecimal salesPrice;
    private Byte enable;
    private BigDecimal inspectionHours;
    private String bargainer;
    private String customsCode;
    private String declareTitleEn;
    private String declareTitleCn;
    private String pickTitleCn;
    private String pickTitleEn;
    private String productNature;
    private String chargerSpecifications;
    private BigDecimal packingPrice;
    private String packingName;
    private String packingSize;
    private String productSize;
    private BigDecimal packingWeight;
    private String unit;
    private Byte pushStatus;
    private Integer transferDelivery;
    private Byte source;

    @Id
    @Column(name = "id")
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Basic
    @Column(name = "bailun_sku")
    public String getBailunSku() {
        return bailunSku;
    }

    public void setBailunSku(String bailunSku) {
        this.bailunSku = bailunSku;
    }

    @Basic
    @Column(name = "sku_image")
    public String getSkuImage() {
        return skuImage;
    }

    public void setSkuImage(String skuImage) {
        this.skuImage = skuImage;
    }

    @Basic
    @Column(name = "category_id")
    public Integer getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Integer categoryId) {
        this.categoryId = categoryId;
    }

    @Basic
    @Column(name = "category_name")
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    @Basic
    @Column(name = "warehouse_code")
    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    @Basic
    @Column(name = "warehouse_name")
    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    @Basic
    @Column(name = "unit_price")
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    @Basic
    @Column(name = "seller_id")
    public Integer getSellerId() {
        return sellerId;
    }

    public void setSellerId(Integer sellerId) {
        this.sellerId = sellerId;
    }

    @Basic
    @Column(name = "seller_name")
    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    @Basic
    @Column(name = "length")
    public BigDecimal getLength() {
        return length;
    }

    public void setLength(BigDecimal length) {
        this.length = length;
    }

    @Basic
    @Column(name = "width")
    public BigDecimal getWidth() {
        return width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    @Basic
    @Column(name = "height")
    public BigDecimal getHeight() {
        return height;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    @Basic
    @Column(name = "weight")
    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    @Basic
    @Column(name = "moq")
    public Integer getMoq() {
        return moq;
    }

    public void setMoq(Integer moq) {
        this.moq = moq;
    }

    @Basic
    @Column(name = "sku_title_cn")
    public String getSkuTitleCn() {
        return skuTitleCn;
    }

    public void setSkuTitleCn(String skuTitleCn) {
        this.skuTitleCn = skuTitleCn;
    }

    @Basic
    @Column(name = "sku_title_en")
    public String getSkuTitleEn() {
        return skuTitleEn;
    }

    public void setSkuTitleEn(String skuTitleEn) {
        this.skuTitleEn = skuTitleEn;
    }

    @Basic
    @Column(name = "create_time")
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    @Basic
    @Column(name = "update_time")
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Basic
    @Column(name = "gmt_create")
    public LocalDateTime getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    @Basic
    @Column(name = "gmt_modified")
    public LocalDateTime getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(LocalDateTime gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Basic
    @Column(name = "suppliers_id")
    public Integer getSuppliersId() {
        return suppliersId;
    }

    public void setSuppliersId(Integer suppliersId) {
        this.suppliersId = suppliersId;
    }

    @Basic
    @Column(name = "suppliers_name")
    public String getSuppliersName() {
        return suppliersName;
    }

    public void setSuppliersName(String suppliersName) {
        this.suppliersName = suppliersName;
    }

    @Basic
    @Column(name = "supplier_delivery")
    public Integer getSupplierDelivery() {
        return supplierDelivery;
    }

    public void setSupplierDelivery(Integer supplierDelivery) {
        this.supplierDelivery = supplierDelivery;
    }

    @Basic
    @Column(name = "currency")
    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Basic
    @Column(name = "buyer_name")
    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    @Basic
    @Column(name = "buyer_id")
    public Integer getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(Integer buyerId) {
        this.buyerId = buyerId;
    }

    @Basic
    @Column(name = "internal_moq")
    public Integer getInternalMoq() {
        return internalMoq;
    }

    public void setInternalMoq(Integer internalMoq) {
        this.internalMoq = internalMoq;
    }

    @Basic
    @Column(name = "bussiness_id")
    public Integer getBussinessId() {
        return bussinessId;
    }

    public void setBussinessId(Integer bussinessId) {
        this.bussinessId = bussinessId;
    }

    @Basic
    @Column(name = "bussiness_name")
    public String getBussinessName() {
        return bussinessName;
    }

    public void setBussinessName(String bussinessName) {
        this.bussinessName = bussinessName;
    }

    @Basic
    @Column(name = "status")
    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    @Basic
    @Column(name = "type")
    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    @Basic
    @Column(name = "product_code")
    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    @Basic
    @Column(name = "bailun_inner_sku")
    public String getBailunInnerSku() {
        return bailunInnerSku;
    }

    public void setBailunInnerSku(String bailunInnerSku) {
        this.bailunInnerSku = bailunInnerSku;
    }

    @Basic
    @Column(name = "product_inner_code")
    public String getProductInnerCode() {
        return productInnerCode;
    }

    public void setProductInnerCode(String productInnerCode) {
        this.productInnerCode = productInnerCode;
    }

    @Basic
    @Column(name = "skums_id")
    public Integer getSkumsId() {
        return skumsId;
    }

    public void setSkumsId(Integer skumsId) {
        this.skumsId = skumsId;
    }

    @Basic
    @Column(name = "suppliers_link")
    public String getSuppliersLink() {
        return suppliersLink;
    }

    public void setSuppliersLink(String suppliersLink) {
        this.suppliersLink = suppliersLink;
    }

    @Basic
    @Column(name = "bailun_category_id")
    public Integer getBailunCategoryId() {
        return bailunCategoryId;
    }

    public void setBailunCategoryId(Integer bailunCategoryId) {
        this.bailunCategoryId = bailunCategoryId;
    }

    @Basic
    @Column(name = "bailun_category_name")
    public String getBailunCategoryName() {
        return bailunCategoryName;
    }

    public void setBailunCategoryName(String bailunCategoryName) {
        this.bailunCategoryName = bailunCategoryName;
    }

    @Basic
    @Column(name = "color")
    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @Basic
    @Column(name = "specifications")
    public String getSpecifications() {
        return specifications;
    }

    public void setSpecifications(String specifications) {
        this.specifications = specifications;
    }

    @Basic
    @Column(name = "create_name")
    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    @Basic
    @Column(name = "update_name")
    public String getUpdateName() {
        return updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }

    @Basic
    @Column(name = "virtual_price")
    public BigDecimal getVirtualPrice() {
        return virtualPrice;
    }

    public void setVirtualPrice(BigDecimal virtualPrice) {
        this.virtualPrice = virtualPrice;
    }

    @Basic
    @Column(name = "size_image")
    public String getSizeImage() {
        return sizeImage;
    }

    public void setSizeImage(String sizeImage) {
        this.sizeImage = sizeImage;
    }

    @Basic
    @Column(name = "sales_price")
    public BigDecimal getSalesPrice() {
        return salesPrice;
    }

    public void setSalesPrice(BigDecimal salesPrice) {
        this.salesPrice = salesPrice;
    }

    @Basic
    @Column(name = "enable")
    public Byte getEnable() {
        return enable;
    }

    public void setEnable(Byte enable) {
        this.enable = enable;
    }

    @Basic
    @Column(name = "inspection_hours")
    public BigDecimal getInspectionHours() {
        return inspectionHours;
    }

    public void setInspectionHours(BigDecimal inspectionHours) {
        this.inspectionHours = inspectionHours;
    }

    @Basic
    @Column(name = "bargainer")
    public String getBargainer() {
        return bargainer;
    }

    public void setBargainer(String bargainer) {
        this.bargainer = bargainer;
    }

    @Basic
    @Column(name = "customs_code")
    public String getCustomsCode() {
        return customsCode;
    }

    public void setCustomsCode(String customsCode) {
        this.customsCode = customsCode;
    }

    @Basic
    @Column(name = "declare_title_en")
    public String getDeclareTitleEn() {
        return declareTitleEn;
    }

    public void setDeclareTitleEn(String declareTitleEn) {
        this.declareTitleEn = declareTitleEn;
    }

    @Basic
    @Column(name = "declare_title_cn")
    public String getDeclareTitleCn() {
        return declareTitleCn;
    }

    public void setDeclareTitleCn(String declareTitleCn) {
        this.declareTitleCn = declareTitleCn;
    }

    @Basic
    @Column(name = "pick_title_cn")
    public String getPickTitleCn() {
        return pickTitleCn;
    }

    public void setPickTitleCn(String pickTitleCn) {
        this.pickTitleCn = pickTitleCn;
    }

    @Basic
    @Column(name = "pick_title_en")
    public String getPickTitleEn() {
        return pickTitleEn;
    }

    public void setPickTitleEn(String pickTitleEn) {
        this.pickTitleEn = pickTitleEn;
    }

    @Basic
    @Column(name = "product_nature")
    public String getProductNature() {
        return productNature;
    }

    public void setProductNature(String productNature) {
        this.productNature = productNature;
    }

    @Basic
    @Column(name = "charger_specifications")
    public String getChargerSpecifications() {
        return chargerSpecifications;
    }

    public void setChargerSpecifications(String chargerSpecifications) {
        this.chargerSpecifications = chargerSpecifications;
    }

    @Basic
    @Column(name = "packing_price")
    public BigDecimal getPackingPrice() {
        return packingPrice;
    }

    public void setPackingPrice(BigDecimal packingPrice) {
        this.packingPrice = packingPrice;
    }

    @Basic
    @Column(name = "packing_name")
    public String getPackingName() {
        return packingName;
    }

    public void setPackingName(String packingName) {
        this.packingName = packingName;
    }

    @Basic
    @Column(name = "packing_size")
    public String getPackingSize() {
        return packingSize;
    }

    public void setPackingSize(String packingSize) {
        this.packingSize = packingSize;
    }

    @Basic
    @Column(name = "product_size")
    public String getProductSize() {
        return productSize;
    }

    public void setProductSize(String productSize) {
        this.productSize = productSize;
    }

    @Basic
    @Column(name = "packing_weight")
    public BigDecimal getPackingWeight() {
        return packingWeight;
    }

    public void setPackingWeight(BigDecimal packingWeight) {
        this.packingWeight = packingWeight;
    }

    @Basic
    @Column(name = "unit")
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Basic
    @Column(name = "push_status")
    public Byte getPushStatus() {
        return pushStatus;
    }

    public void setPushStatus(Byte pushStatus) {
        this.pushStatus = pushStatus;
    }

    @Basic
    @Column(name = "transfer_delivery")
    public Integer getTransferDelivery() {
        return transferDelivery;
    }

    public void setTransferDelivery(Integer transferDelivery) {
        this.transferDelivery = transferDelivery;
    }

    @Basic
    @Column(name = "source")
    public Byte getSource() {
        return source;
    }

    public void setSource(Byte source) {
        this.source = source;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DcBaseSku dcBaseSku = (DcBaseSku) o;

        if (id != null ? !id.equals(dcBaseSku.id) : dcBaseSku.id != null) return false;
        if (bailunSku != null ? !bailunSku.equals(dcBaseSku.bailunSku) : dcBaseSku.bailunSku != null) return false;
        if (skuImage != null ? !skuImage.equals(dcBaseSku.skuImage) : dcBaseSku.skuImage != null) return false;
        if (categoryId != null ? !categoryId.equals(dcBaseSku.categoryId) : dcBaseSku.categoryId != null) return false;
        if (categoryName != null ? !categoryName.equals(dcBaseSku.categoryName) : dcBaseSku.categoryName != null)
            return false;
        if (warehouseCode != null ? !warehouseCode.equals(dcBaseSku.warehouseCode) : dcBaseSku.warehouseCode != null)
            return false;
        if (warehouseName != null ? !warehouseName.equals(dcBaseSku.warehouseName) : dcBaseSku.warehouseName != null)
            return false;
        if (unitPrice != null ? !unitPrice.equals(dcBaseSku.unitPrice) : dcBaseSku.unitPrice != null) return false;
        if (sellerId != null ? !sellerId.equals(dcBaseSku.sellerId) : dcBaseSku.sellerId != null) return false;
        if (sellerName != null ? !sellerName.equals(dcBaseSku.sellerName) : dcBaseSku.sellerName != null) return false;
        if (length != null ? !length.equals(dcBaseSku.length) : dcBaseSku.length != null) return false;
        if (width != null ? !width.equals(dcBaseSku.width) : dcBaseSku.width != null) return false;
        if (height != null ? !height.equals(dcBaseSku.height) : dcBaseSku.height != null) return false;
        if (weight != null ? !weight.equals(dcBaseSku.weight) : dcBaseSku.weight != null) return false;
        if (moq != null ? !moq.equals(dcBaseSku.moq) : dcBaseSku.moq != null) return false;
        if (skuTitleCn != null ? !skuTitleCn.equals(dcBaseSku.skuTitleCn) : dcBaseSku.skuTitleCn != null) return false;
        if (skuTitleEn != null ? !skuTitleEn.equals(dcBaseSku.skuTitleEn) : dcBaseSku.skuTitleEn != null) return false;
        if (createTime != null ? !createTime.equals(dcBaseSku.createTime) : dcBaseSku.createTime != null) return false;
        if (updateTime != null ? !updateTime.equals(dcBaseSku.updateTime) : dcBaseSku.updateTime != null) return false;
        if (gmtCreate != null ? !gmtCreate.equals(dcBaseSku.gmtCreate) : dcBaseSku.gmtCreate != null) return false;
        if (gmtModified != null ? !gmtModified.equals(dcBaseSku.gmtModified) : dcBaseSku.gmtModified != null)
            return false;
        if (suppliersId != null ? !suppliersId.equals(dcBaseSku.suppliersId) : dcBaseSku.suppliersId != null)
            return false;
        if (suppliersName != null ? !suppliersName.equals(dcBaseSku.suppliersName) : dcBaseSku.suppliersName != null)
            return false;
        if (supplierDelivery != null ? !supplierDelivery.equals(dcBaseSku.supplierDelivery) : dcBaseSku.supplierDelivery != null)
            return false;
        if (currency != null ? !currency.equals(dcBaseSku.currency) : dcBaseSku.currency != null) return false;
        if (buyerName != null ? !buyerName.equals(dcBaseSku.buyerName) : dcBaseSku.buyerName != null) return false;
        if (buyerId != null ? !buyerId.equals(dcBaseSku.buyerId) : dcBaseSku.buyerId != null) return false;
        if (internalMoq != null ? !internalMoq.equals(dcBaseSku.internalMoq) : dcBaseSku.internalMoq != null)
            return false;
        if (bussinessId != null ? !bussinessId.equals(dcBaseSku.bussinessId) : dcBaseSku.bussinessId != null)
            return false;
        if (bussinessName != null ? !bussinessName.equals(dcBaseSku.bussinessName) : dcBaseSku.bussinessName != null)
            return false;
        if (status != null ? !status.equals(dcBaseSku.status) : dcBaseSku.status != null) return false;
        if (type != null ? !type.equals(dcBaseSku.type) : dcBaseSku.type != null) return false;
        if (productCode != null ? !productCode.equals(dcBaseSku.productCode) : dcBaseSku.productCode != null)
            return false;
        if (bailunInnerSku != null ? !bailunInnerSku.equals(dcBaseSku.bailunInnerSku) : dcBaseSku.bailunInnerSku != null)
            return false;
        if (productInnerCode != null ? !productInnerCode.equals(dcBaseSku.productInnerCode) : dcBaseSku.productInnerCode != null)
            return false;
        if (skumsId != null ? !skumsId.equals(dcBaseSku.skumsId) : dcBaseSku.skumsId != null) return false;
        if (suppliersLink != null ? !suppliersLink.equals(dcBaseSku.suppliersLink) : dcBaseSku.suppliersLink != null)
            return false;
        if (bailunCategoryId != null ? !bailunCategoryId.equals(dcBaseSku.bailunCategoryId) : dcBaseSku.bailunCategoryId != null)
            return false;
        if (bailunCategoryName != null ? !bailunCategoryName.equals(dcBaseSku.bailunCategoryName) : dcBaseSku.bailunCategoryName != null)
            return false;
        if (color != null ? !color.equals(dcBaseSku.color) : dcBaseSku.color != null) return false;
        if (specifications != null ? !specifications.equals(dcBaseSku.specifications) : dcBaseSku.specifications != null)
            return false;
        if (createName != null ? !createName.equals(dcBaseSku.createName) : dcBaseSku.createName != null) return false;
        if (updateName != null ? !updateName.equals(dcBaseSku.updateName) : dcBaseSku.updateName != null) return false;
        if (virtualPrice != null ? !virtualPrice.equals(dcBaseSku.virtualPrice) : dcBaseSku.virtualPrice != null)
            return false;
        if (sizeImage != null ? !sizeImage.equals(dcBaseSku.sizeImage) : dcBaseSku.sizeImage != null) return false;
        if (salesPrice != null ? !salesPrice.equals(dcBaseSku.salesPrice) : dcBaseSku.salesPrice != null) return false;
        if (enable != null ? !enable.equals(dcBaseSku.enable) : dcBaseSku.enable != null) return false;
        if (inspectionHours != null ? !inspectionHours.equals(dcBaseSku.inspectionHours) : dcBaseSku.inspectionHours != null)
            return false;
        if (bargainer != null ? !bargainer.equals(dcBaseSku.bargainer) : dcBaseSku.bargainer != null) return false;
        if (customsCode != null ? !customsCode.equals(dcBaseSku.customsCode) : dcBaseSku.customsCode != null)
            return false;
        if (declareTitleEn != null ? !declareTitleEn.equals(dcBaseSku.declareTitleEn) : dcBaseSku.declareTitleEn != null)
            return false;
        if (declareTitleCn != null ? !declareTitleCn.equals(dcBaseSku.declareTitleCn) : dcBaseSku.declareTitleCn != null)
            return false;
        if (pickTitleCn != null ? !pickTitleCn.equals(dcBaseSku.pickTitleCn) : dcBaseSku.pickTitleCn != null)
            return false;
        if (pickTitleEn != null ? !pickTitleEn.equals(dcBaseSku.pickTitleEn) : dcBaseSku.pickTitleEn != null)
            return false;
        if (productNature != null ? !productNature.equals(dcBaseSku.productNature) : dcBaseSku.productNature != null)
            return false;
        if (chargerSpecifications != null ? !chargerSpecifications.equals(dcBaseSku.chargerSpecifications) : dcBaseSku.chargerSpecifications != null)
            return false;
        if (packingPrice != null ? !packingPrice.equals(dcBaseSku.packingPrice) : dcBaseSku.packingPrice != null)
            return false;
        if (packingName != null ? !packingName.equals(dcBaseSku.packingName) : dcBaseSku.packingName != null)
            return false;
        if (packingSize != null ? !packingSize.equals(dcBaseSku.packingSize) : dcBaseSku.packingSize != null)
            return false;
        if (productSize != null ? !productSize.equals(dcBaseSku.productSize) : dcBaseSku.productSize != null)
            return false;
        if (packingWeight != null ? !packingWeight.equals(dcBaseSku.packingWeight) : dcBaseSku.packingWeight != null)
            return false;
        if (unit != null ? !unit.equals(dcBaseSku.unit) : dcBaseSku.unit != null) return false;
        if (pushStatus != null ? !pushStatus.equals(dcBaseSku.pushStatus) : dcBaseSku.pushStatus != null) return false;
        if (transferDelivery != null ? !transferDelivery.equals(dcBaseSku.transferDelivery) : dcBaseSku.transferDelivery != null)
            return false;
        if (source != null ? !source.equals(dcBaseSku.source) : dcBaseSku.source != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (bailunSku != null ? bailunSku.hashCode() : 0);
        result = 31 * result + (skuImage != null ? skuImage.hashCode() : 0);
        result = 31 * result + (categoryId != null ? categoryId.hashCode() : 0);
        result = 31 * result + (categoryName != null ? categoryName.hashCode() : 0);
        result = 31 * result + (warehouseCode != null ? warehouseCode.hashCode() : 0);
        result = 31 * result + (warehouseName != null ? warehouseName.hashCode() : 0);
        result = 31 * result + (unitPrice != null ? unitPrice.hashCode() : 0);
        result = 31 * result + (sellerId != null ? sellerId.hashCode() : 0);
        result = 31 * result + (sellerName != null ? sellerName.hashCode() : 0);
        result = 31 * result + (length != null ? length.hashCode() : 0);
        result = 31 * result + (width != null ? width.hashCode() : 0);
        result = 31 * result + (height != null ? height.hashCode() : 0);
        result = 31 * result + (weight != null ? weight.hashCode() : 0);
        result = 31 * result + (moq != null ? moq.hashCode() : 0);
        result = 31 * result + (skuTitleCn != null ? skuTitleCn.hashCode() : 0);
        result = 31 * result + (skuTitleEn != null ? skuTitleEn.hashCode() : 0);
        result = 31 * result + (createTime != null ? createTime.hashCode() : 0);
        result = 31 * result + (updateTime != null ? updateTime.hashCode() : 0);
        result = 31 * result + (gmtCreate != null ? gmtCreate.hashCode() : 0);
        result = 31 * result + (gmtModified != null ? gmtModified.hashCode() : 0);
        result = 31 * result + (suppliersId != null ? suppliersId.hashCode() : 0);
        result = 31 * result + (suppliersName != null ? suppliersName.hashCode() : 0);
        result = 31 * result + (supplierDelivery != null ? supplierDelivery.hashCode() : 0);
        result = 31 * result + (currency != null ? currency.hashCode() : 0);
        result = 31 * result + (buyerName != null ? buyerName.hashCode() : 0);
        result = 31 * result + (buyerId != null ? buyerId.hashCode() : 0);
        result = 31 * result + (internalMoq != null ? internalMoq.hashCode() : 0);
        result = 31 * result + (bussinessId != null ? bussinessId.hashCode() : 0);
        result = 31 * result + (bussinessName != null ? bussinessName.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (type != null ? type.hashCode() : 0);
        result = 31 * result + (productCode != null ? productCode.hashCode() : 0);
        result = 31 * result + (bailunInnerSku != null ? bailunInnerSku.hashCode() : 0);
        result = 31 * result + (productInnerCode != null ? productInnerCode.hashCode() : 0);
        result = 31 * result + (skumsId != null ? skumsId.hashCode() : 0);
        result = 31 * result + (suppliersLink != null ? suppliersLink.hashCode() : 0);
        result = 31 * result + (bailunCategoryId != null ? bailunCategoryId.hashCode() : 0);
        result = 31 * result + (bailunCategoryName != null ? bailunCategoryName.hashCode() : 0);
        result = 31 * result + (color != null ? color.hashCode() : 0);
        result = 31 * result + (specifications != null ? specifications.hashCode() : 0);
        result = 31 * result + (createName != null ? createName.hashCode() : 0);
        result = 31 * result + (updateName != null ? updateName.hashCode() : 0);
        result = 31 * result + (virtualPrice != null ? virtualPrice.hashCode() : 0);
        result = 31 * result + (sizeImage != null ? sizeImage.hashCode() : 0);
        result = 31 * result + (salesPrice != null ? salesPrice.hashCode() : 0);
        result = 31 * result + (enable != null ? enable.hashCode() : 0);
        result = 31 * result + (inspectionHours != null ? inspectionHours.hashCode() : 0);
        result = 31 * result + (bargainer != null ? bargainer.hashCode() : 0);
        result = 31 * result + (customsCode != null ? customsCode.hashCode() : 0);
        result = 31 * result + (declareTitleEn != null ? declareTitleEn.hashCode() : 0);
        result = 31 * result + (declareTitleCn != null ? declareTitleCn.hashCode() : 0);
        result = 31 * result + (pickTitleCn != null ? pickTitleCn.hashCode() : 0);
        result = 31 * result + (pickTitleEn != null ? pickTitleEn.hashCode() : 0);
        result = 31 * result + (productNature != null ? productNature.hashCode() : 0);
        result = 31 * result + (chargerSpecifications != null ? chargerSpecifications.hashCode() : 0);
        result = 31 * result + (packingPrice != null ? packingPrice.hashCode() : 0);
        result = 31 * result + (packingName != null ? packingName.hashCode() : 0);
        result = 31 * result + (packingSize != null ? packingSize.hashCode() : 0);
        result = 31 * result + (productSize != null ? productSize.hashCode() : 0);
        result = 31 * result + (packingWeight != null ? packingWeight.hashCode() : 0);
        result = 31 * result + (unit != null ? unit.hashCode() : 0);
        result = 31 * result + (pushStatus != null ? pushStatus.hashCode() : 0);
        result = 31 * result + (transferDelivery != null ? transferDelivery.hashCode() : 0);
        result = 31 * result + (source != null ? source.hashCode() : 0);
        return result;
    }
}
