package com.bailuntec.listener;

import com.bailuntec.domain.constant.CommonConstant;
import com.bailuntec.domain.constant.Constant;
import com.bailuntec.domain.entity.DcMidCostFirst;
import com.bailuntec.domain.example.DcMidCostFirstExample;
import com.bailuntec.domain.pojo.MidCostFirst;
import com.bailuntec.mapper.DcMidCostFirstMapper;
import com.bailuntec.mapper.DcMidCostFirstOrderMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class CalculateCostFirstListener implements ElasticJobListener {

    @Override
    public void beforeJobExecuted(ShardingContexts shardingContexts) {

    }

    @Override
    public void afterJobExecuted(ShardingContexts shardingContexts) {
        DcMidCostFirstOrderMapper dcMidCostFirstOrderMapper = SessionUtil.getSession().getMapper(DcMidCostFirstOrderMapper.class);
        DcMidCostFirstMapper dcMidCostFirsMapper = SessionUtil.getSession().getMapper(DcMidCostFirstMapper.class);
        int countSkuWarehouse = dcMidCostFirstOrderMapper.countSkuWarehouse();
        int skuWarehouseTotalPage = getSkuWarehouseTotalPage(countSkuWarehouse);
        int index = 0;
        do {
            List<MidCostFirst> midCostFirstList = dcMidCostFirstOrderMapper.listSkuWarehouse(index * Constant.PAGE_SIZE,Constant.PAGE_SIZE);
            if (midCostFirstList != null && midCostFirstList.size() > 0) {
                DcMidCostFirst dcMidCostFirst = new DcMidCostFirst();
                for (MidCostFirst midCostFirst : midCostFirstList) {
                    dcMidCostFirst.setBailunSku(midCostFirst.getBailunSku());
                    dcMidCostFirst.setWarehouseCode(midCostFirst.getWarehouseCode());
                    BigDecimal costFirst = midCostFirst.getTotalCostFirst().divide(BigDecimal.valueOf(midCostFirst.getTotalCount()), 3 , RoundingMode.HALF_EVEN);
                    dcMidCostFirst.setCostFirst(costFirst);
                    int i = dcMidCostFirsMapper.updateByExampleSelective(dcMidCostFirst,DcMidCostFirstExample.newAndCreateCriteria().andBailunSkuEqualTo(dcMidCostFirst.getBailunSku()).andWarehouseCodeEqualTo(dcMidCostFirst.getWarehouseCode()).example());
                    if (i == 0) {
                        dcMidCostFirsMapper.insertSelective(dcMidCostFirst);
                    }
                }
            }
            index++;
        } while (index < skuWarehouseTotalPage);
    }

    private int getSkuWarehouseTotalPage(int countSkuWarehouse) {
        if (countSkuWarehouse % Constant.PAGE_SIZE == 0) {
            return countSkuWarehouse / Constant.PAGE_SIZE;
        }
        return countSkuWarehouse / Constant.PAGE_SIZE + 1;
    }
}
