package com.bailuntec.job;

import com.bailuntec.mapper.DcDailySalesMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;

public class CalculateSalesJob implements SimpleJob {
    @Override
    public void execute(ShardingContext shardingContext) {
        try {
            DcDailySalesMapper mapper = SessionUtil.getSession().getMapper(DcDailySalesMapper.class);
            mapper.calculateSales();
            SessionUtil.getSession().commit();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("MYBATIS操作DB失败");
        } finally {
            SessionUtil.closeSession();
        }
    }
}
