package com.bailuntec.job;


import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.JobPointLogExample;
import com.bailuntec.mapper.JobPointLogMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import org.apache.ibatis.session.SqlSession;
import org.junit.jupiter.api.Test;

import java.util.HashMap;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/8/26 10:21 上午
 */
public class OrderSyncJobTest {


    @Test
    public void execute() {
        PointJob pointJob = new OrderSyncJob();
        ShardingContext shardingContext = new ShardingContext(
                new ShardingContexts("x", "base-sync-oms-order-coroutine", 1, null, new HashMap<>()), 0
        );

        pointJob.execute(shardingContext);
    }

    @Test
    public void executeJob() {
        OrderSyncJob orderSyncJob = new OrderSyncJob();
        ShardingContext shardingContext = new ShardingContext(
                new ShardingContexts("x", "base-sync-oms-order-coroutine", 1, null, new HashMap<>()), 0
        );

        SqlSession sqlSession = SessionUtil.getFactory().openSession(true);
        JobPointLogMapper jobPointLogMapper = sqlSession.getMapper(JobPointLogMapper.class);
        JobPointLog jobPointLog = jobPointLogMapper.selectOneByExample(JobPointLogExample
                .newAndCreateCriteria()
                .andJobNameEqualTo(shardingContext.getJobName()).example());

        jobPointLog.setPageIndex(0);
        orderSyncJob.executeJob(shardingContext, jobPointLog);
        sqlSession.close();
    }


}
