package com.bailuntec.domain.pojo;

import lombok.Data;

@Data
public class CommonSkuCondition {

    private String beginCT;//创建时间-begin

    private String endCT;//创建时间-end

    private String updateDate; //更新时间

    /// <summary>
    /// 返回数据类型，1正常，2分页，99导出
    /// </summary>
    private Integer resultType;

    /// <summary>
    /// 查询内容
    /// 1-1主要基础,1-2规格,1-3基础其他，2开发，3状态，4供应商，5商品,例：1-1,2,3
    /// </summary>
    private String resultContent;

    /// <summary>
    /// sku(多个sku以,间隔，上限1000)
    /// </summary>
    private String skus;

    /// <summary>
    /// 页数
    /// </summary>
    private Integer page;

    /// <summary>
    /// 分页大小，最大1000
    /// </summary>
    private Integer pageSize;

    /// <summary>
    /// 排序列
    /// </summary>
    private String sortField;

    /// <summary>
    /// 排序方式 asc或desc
    /// </summary>
    private String sort;

    /// <summary>
    /// 查询类型 1产品编码，2商品编码，3标题模糊查询，4内部商品编码，5内部产品编码
    /// </summary>
    private Integer searchType;

    /// <summary>
    /// 查询值
    /// </summary>
    private String search;

    /// <summary>
    /// 采购员Id
    /// </summary>
    private Integer buyerId;

    /// <summary>
    /// 销售员Id
    /// </summary>
    private Integer sellerId;

    /// <summary>
    /// 商品状态 1停售，2在售
    /// </summary>
    private Integer status;

    /// <summary>
    /// 是否成品 -1,都返回 1成品，2半成品，3耗材，4固定资产，5组合SKU
    /// </summary>
    private Integer isFinish;

    /// <summary>
    /// 是否返回供应商 1是返回sku对应供应商列表，2否不返回
    /// </summary>
    private Integer isResultSup;

    /// <summary>
    /// 是否返回仓库信息
    /// </summary>
    private Integer isResultWare;



}
