import com.alibaba.fastjson.JSON;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.JobPointLogExample;
import com.bailuntec.domain.pojo.OmsResultInfo;
import com.bailuntec.domain.pojo.OmsResultRoot;
import com.bailuntec.job.OrderSyncJob;
import com.bailuntec.mapper.JobPointLogMapper;
import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.SessionUtil;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class OmsOrderTest {


    @Test
    public void test1() {
        OkHttpClient okHttpClient = OkHttpUtil.getInstance();
        LinkedHashMap<String, String> map = new LinkedHashMap<>(4);
        map.put("pageIndex", "1");
        map.put("pageCount", "100");
        map.put("BailunLastUpdateTimeFrom", "2019-03-05 14:00:00");
        map.put("BailunLastUpdateTimeTo", "2019-03-05 15:00:00");
        Request request = new Request.Builder()
                .get()
                .url(OkHttpUtil.attachHttpGetParams("http://oms.bailuntec.com/apiV2/bailunOrder/getBailunOrders", map))
                .addHeader("Content-Type", "application/json")
                .build();
        Response response = null;
        String omsResultStr = null;
        try {
            response = okHttpClient.newCall(request).execute();
            omsResultStr = response.body().string();
        } catch (IOException e) {
            throw new RuntimeException(map + "请求OMS接口同步百伦接口失败" + response, e);
        } finally {
            if (response != null) {
                response.close();
            }
        }
        OrderSyncJob orderSyncJob = new OrderSyncJob();
        if (StringUtils.isNoneBlank(omsResultStr)) {
            OmsResultRoot omsResultRoot = JSON.parseObject(omsResultStr, OmsResultRoot.class);
            if (omsResultRoot != null && omsResultRoot.getSuccess().booleanValue()) {
                OmsResultInfo omsResultInfo = omsResultRoot.getResult();
                if (omsResultInfo.getResult() != null && omsResultInfo.getResult().size() > 0) {
                    orderSyncJob.analyseOmsOrder(omsResultInfo.getResult());
                }
            } else {
                throw new RuntimeException("调用OMS接口同步百伦订单失败, 响应200, 请求参数" + map.toString());
            }
        }
    }
    @Test
    public void test4() {
        OrderSyncJob orderSyncJob = new OrderSyncJob();
        JobPointLog jobPointLog = null;
        try {
            JobPointLogMapper mapper = SessionUtil.getSession().getMapper(JobPointLogMapper.class);
            jobPointLog = mapper.selectOneByExample(JobPointLogExample.newAndCreateCriteria().andJobNameEqualTo("base-sync-oms-order").example());
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            SessionUtil.closeSession();
        }
        orderSyncJob.executeJob(null, jobPointLog);
    }

    @Test
    public void test() {
        OkHttpClient okHttpClient = OkHttpUtil.getInstance();
        LinkedHashMap<String, String> map = new LinkedHashMap<>(4);
        map.put("pageIndex", "1");
        map.put("pageCount", "100");
        map.put("OriginOrderNo", "99594644121548");
        Request request = new Request.Builder()
                .get()
                .url(OkHttpUtil.attachHttpGetParams("http://oms.bailuntec.com/apiV2/bailunOrder/getBailunOrders", map))
                .addHeader("Content-Type", "application/json")
                .build();
        Response response = null;
        String omsResultStr = null;
        try {
            response = okHttpClient.newCall(request).execute();
            omsResultStr = response.body().string();
        } catch (IOException e) {
            throw new RuntimeException(map + "请求OMS接口同步百伦接口失败" + response, e);
        } finally {
            if (response != null) {
                response.close();
            }
        }
        OrderSyncJob orderSyncJob = new OrderSyncJob();
        if (StringUtils.isNoneBlank(omsResultStr)) {
            OmsResultRoot omsResultRoot = JSON.parseObject(omsResultStr, OmsResultRoot.class);
            if (omsResultRoot != null && omsResultRoot.getSuccess().booleanValue()) {
                OmsResultInfo omsResultInfo = omsResultRoot.getResult();
                if (omsResultInfo.getResult() != null && omsResultInfo.getResult().size() > 0) {
                    orderSyncJob.analyseOmsOrder(omsResultInfo.getResult());
                }
            } else {
                throw new RuntimeException("调用OMS接口同步百伦订单失败, 响应200, 请求参数" + map.toString());
            }
        }
    }

    @Test
    public void test2() {
        List<String> orderNoList = new ArrayList<>();
         orderNoList.add("96762719802850"); 
         orderNoList.add("507848489621470"); 
         orderNoList.add("98708700265674"); 
         orderNoList.add("98544763332172"); 
         orderNoList.add("507914485394232"); 
         orderNoList.add("507948413713888"); 
         orderNoList.add("114-8101649-8787465"); 
         orderNoList.add("405-3057912-4884303"); 
         orderNoList.add("98705361870833"); 
         orderNoList.add("99030672260151"); 
         orderNoList.add("99072518534799"); 
         orderNoList.add("98998302731398"); 
         orderNoList.add("5c8554281bcf64603232d189"); 
         orderNoList.add("704021144108944"); 
         orderNoList.add("98924496380232"); 
         orderNoList.add("99168711273730"); 
         orderNoList.add("99206676609330"); 
         orderNoList.add("98972176312994"); 
         orderNoList.add("99149669860798"); 
         orderNoList.add("99057532558921"); 
         orderNoList.add("99350751025613"); 
         orderNoList.add("99244340829233"); 
         orderNoList.add("EB2019030306574411B44C1C"); 
         orderNoList.add("EB20190304005647BBFE6D9F"); 
         orderNoList.add("RMA-94789525543011"); 
         orderNoList.add("EB20190309052838ED50CB0D"); 
         orderNoList.add("EB20190309182500DA64E5D3"); 
         orderNoList.add("EB201903102100453C9A9ADF"); 
         orderNoList.add("EB201903111001178A8CC64F"); 
         orderNoList.add("EB20190311215718CF7DAFC4"); 
         orderNoList.add("EB20190311222730A00321BE"); 
         orderNoList.add("EB20190312003929A4868CB5"); 
         orderNoList.add("EB2019031200590531CFF790"); 
         orderNoList.add("EB20190312033242836E4669"); 
         orderNoList.add("EB20190312203814A9475523"); 
         orderNoList.add("EB20190312231012C5BF1BD7"); 
         orderNoList.add("EB29K69728J2269282F"); 
         orderNoList.add("EB20190313013538F41C5D10"); 
         orderNoList.add("EB2019031302105141799AB6"); 
         orderNoList.add("EB20190313034723B1FA62C2"); 
         orderNoList.add("EB201903130617401E1F1007"); 
         orderNoList.add("508148920502404"); 
         orderNoList.add("508266627042404"); 
         orderNoList.add("900060295682799"); 
         orderNoList.add("99647989995386"); 
         orderNoList.add("900060620932799"); 
         orderNoList.add("99648387711464"); 
         orderNoList.add("99462806481464"); 
         orderNoList.add("99769875885386"); 
         orderNoList.add("99524731245386"); 
         orderNoList.add("333107208232-1632603389014"); 
         orderNoList.add("333107208232-1632602911014"); 
         orderNoList.add("292961237178-1666127941019"); 
         orderNoList.add("292961237178-1666128532019"); 
         orderNoList.add("EB8NN87499DE0263116"); 
         orderNoList.add("EB20190313081224E525D89F"); 
         orderNoList.add("EB201903130819178EBEDF7F"); 
         orderNoList.add("EB20190313084854B9A86E44"); 
         orderNoList.add("EB2019031309093769BD1F2D"); 
         orderNoList.add("508160130489593"); 
         orderNoList.add("508278992910239"); 
         orderNoList.add("99654382223398"); 



        for (String s : orderNoList) {
            OkHttpClient okHttpClient = OkHttpUtil.getInstance();
            LinkedHashMap<String, String> map = new LinkedHashMap<>(4);
            map.put("pageIndex", "1");
            map.put("pageCount", "100");
            map.put("OriginOrderNo", s);
            Request request = new Request.Builder()
                    .get()
                    .url(OkHttpUtil.attachHttpGetParams("http://oms.bailuntec.com/apiV2/bailunOrder/getBailunOrders", map))
                    .addHeader("Content-Type", "application/json")
                    .build();
            Response response = null;
            String omsResultStr = null;
            try {
                response = okHttpClient.newCall(request).execute();
                omsResultStr = response.body().string();
            } catch (IOException e) {
                throw new RuntimeException(map + "请求OMS接口同步百伦接口失败" + response, e);
            } finally {
                if (response != null) {
                    response.close();
                }
            }
            OrderSyncJob orderSyncJob = new OrderSyncJob();
            if (StringUtils.isNoneBlank(omsResultStr)) {
                OmsResultRoot omsResultRoot = JSON.parseObject(omsResultStr, OmsResultRoot.class);
                if (omsResultRoot != null && omsResultRoot.getSuccess().booleanValue()) {
                    OmsResultInfo omsResultInfo = omsResultRoot.getResult();
                    if (omsResultInfo.getResult() != null && omsResultInfo.getResult().size() > 0) {
                        orderSyncJob.analyseOmsOrder(omsResultInfo.getResult());
                    }
                } else {
                    throw new RuntimeException("调用OMS接口同步百伦订单失败, 响应200, 请求参数" + map.toString());
                }
            }
        }
    }
}
