package com.bailuntec.job;


import com.bailuntec.domain.dto.SalesVolumeWeekDTO;
import com.bailuntec.domain.entity.DcAutoWeekSales;
import com.bailuntec.domain.entity.DcBaseStock;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.DcBaseStockExample;
import com.bailuntec.mapper.DcAutoSalesMapper;
import com.bailuntec.mapper.DcAutoWeekSalesMapper;
import com.bailuntec.mapper.DcBaseStockMapper;
import com.bailuntec.mapper.JobPointLogMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.ExceptionUtil;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Calendar;
import java.util.List;

public class CalculateWeekJob extends PointJob {

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {

        try{
            long count = 0;
            DcBaseStockMapper baseStockMapper = SessionUtil.getSession().getMapper(DcBaseStockMapper.class);
            if (StringUtils.isBlank(shardingContext.getJobParameter())) {
                count = baseStockMapper.countByExample(DcBaseStockExample.newAndCreateCriteria().example());
            } else {
                count = baseStockMapper.countByExample(DcBaseStockExample.newAndCreateCriteria().andWarehouseCodeEqualTo(shardingContext.getJobParameter()).example());
            }
            int totalPage = (int)(count % jobPointLog.getPageSize() == 0 ? count/jobPointLog.getPageSize() : count/jobPointLog.getPageSize() + 1);
            do{
                List<DcBaseStock> dcBaseStockList = null;//分页查SKU_仓库
                if (jobPointLog.getPageIndex().equals(0)) {
                    jobPointLog.setPageIndex(totalPage);
                }
                try {
                    DcBaseStockMapper baseStockMapperFor = SessionUtil.getSession().getMapper(DcBaseStockMapper.class);
                    if (StringUtils.isBlank(shardingContext.getJobParameter())) {
                        dcBaseStockList = baseStockMapperFor.listStockById(jobPointLog.getPageIndex()*jobPointLog.getPageSize(), jobPointLog.getPageSize());
                    }else{
                        dcBaseStockList = baseStockMapperFor.listStockWarehouseById(jobPointLog.getPageIndex()*jobPointLog.getPageSize(), jobPointLog.getPageSize(), shardingContext.getJobParameter());
                    }
                    DcAutoSalesMapper autoSalesMapper = null;
                    if (dcBaseStockList != null && dcBaseStockList.size() > 0) {
                        for (DcBaseStock dcBaseStock : dcBaseStockList) {
                            autoSalesMapper = SessionUtil.getSession().getMapper(DcAutoSalesMapper.class);
                            SalesVolumeWeekDTO salesVolumeWeekDTO = autoSalesMapper.getSalesVolumeWeekDTO(dcBaseStock.getBailunSku(), dcBaseStock.getWarehouseCode());
                            if(StringUtils.isNotEmpty(salesVolumeWeekDTO.getSalesDetail().trim())) {
                                calculateWeekRate(salesVolumeWeekDTO);
                            }
                        }
                    }
                }catch (Exception e){
                    e.printStackTrace();
                }finally {
                    SessionUtil.closeSession();
                }
                if (jobPointLog.getPageIndex() % 10 == 0) {
                    try {
                        JobPointLogMapper mapper = SessionUtil.getSession().getMapper(JobPointLogMapper.class);
                        mapper.upsertSelective(jobPointLog);
                    } catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(ExceptionUtil.transform(e), e);
                    } finally {
                        SessionUtil.closeSession();
                    }
                }
                jobPointLog.setPageIndex(jobPointLog.getPageIndex() - 1);
            }while(0 < jobPointLog.getPageIndex());
            jobPointLog.setPageIndex(0);
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            SessionUtil.closeSession();
        }
    }

    public void calculateWeekRate(SalesVolumeWeekDTO salesVolumeWeekDTO) {
        try{
            DcAutoWeekSales dcAutoWeekSales = new DcAutoWeekSales();
            DcAutoWeekSalesMapper dcAutoWeekSalesMapper = SessionUtil.getSession().getMapper(DcAutoWeekSalesMapper.class);
            BeanUtils.copyProperties(dcAutoWeekSales, salesVolumeWeekDTO);
            dcAutoWeekSales.setSaleDetail(salesVolumeWeekDTO.getSalesDetail());
          //  dcAutoWeekSales.setRateDetail(salesVolumeWeekDTO.getSalesDetail());
            dcAutoWeekSalesMapper.upsertSelective(dcAutoWeekSales);
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            SessionUtil.closeSession();
        }
    }


    private Calendar getCalendarFormYear(int year){
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        cal.set(Calendar.YEAR, year);
        return cal;
    }

    public String getEndDayOfWeekNo(int year,int weekNo){
        Calendar cal = getCalendarFormYear(year);
        cal.set(Calendar.WEEK_OF_YEAR, weekNo);
        cal.add(Calendar.DAY_OF_WEEK, 6);
        return cal.get(Calendar.YEAR) + "-" + (cal.get(Calendar.MONTH) + 1) + "-" +
                cal.get(Calendar.DAY_OF_MONTH);
    }

    public String getStartDayOfWeekNo(int year,int weekNo){
        Calendar cal = getCalendarFormYear(year);
        cal.set(Calendar.WEEK_OF_YEAR, weekNo);
        return cal.get(Calendar.YEAR) + "-" + (cal.get(Calendar.MONTH) + 1) + "-" +
                cal.get(Calendar.DAY_OF_MONTH);

    }


}
