package com.bailuntec.domain.pojo;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class WmsLogisticsInfo {

    private String targetUrl;
    private Boolean success;
    private String error;
    private String unAuthorizedRequest;
    private Result result;

    @Data
    public class Result{
        private Integer pageIndex;
        private Integer totalPages;
        private Integer total;
        private Boolean hasPreViousPage;
        private Boolean hasNextPage;
        private List<LogisticsInner> result;

        @Data
        public class LogisticsInner{
            @JSONField(name = "id")
            private Integer wmsId;
            @JSONField(name = "company_Code")
            private String companyCode;
            @JSONField(name = "company_Name")
            private String companyName;
            private String billCode;
            private String trackingNo;
            private BigDecimal merchantOutputWeightKg;
            private BigDecimal merchantShipmentCostCny;
            private LocalDateTime merchantReconciliationTime;
            private String reconciliationType;
            private String infoId;
            private BigDecimal outputWeightKg;
            private BigDecimal bailunShipmentCostCny;
            private LocalDateTime shipmentTime;
            private String diffStateType;
            private BigDecimal merchantOutputWeightKgOriginal;
            private BigDecimal merchantShipmentCostSnyOriginal;
            private BigDecimal costDiffDecimal;
            private BigDecimal weightDiffDecimal;
            private String lineName;
            private String feeCode;
            private String remark;
            private String generateBillStatus;
            private String feeProductType;
            private LocalDateTime lastModificationTime;
            private LocalDateTime gmtCreateTime;
            private LocalDateTime gmtModifyTime;
        }
    }


}
