package com.bailuntec.listener;

import com.bailuntec.mapper.DcAutoTurnoverMapper;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;

public class AutoTurnoverJobListener implements ElasticJobListener {
    @Override
    public void beforeJobExecuted(ShardingContexts shardingContexts) {
        try {
            DcAutoTurnoverMapper autoTurnoverMapper = SessionUtil.getSession().getMapper(DcAutoTurnoverMapper.class);
            autoTurnoverMapper.truncateAutoInboundTable();
            autoTurnoverMapper.truncateAutoInventoryTable();
            autoTurnoverMapper.truncateAutoShortSupplyTable();
            autoTurnoverMapper.truncateAutoTurnoverTable();
            autoTurnoverMapper.truncateAutoSalesTable();
            SessionUtil.getSession().commit();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Mybatis操作DB失败", e);
        } finally {
            SessionUtil.closeSession();
        }
    }

    @Override
    public void afterJobExecuted(ShardingContexts shardingContexts) {

    }
}
