package com.bailuntec.job;

import com.bailuntec.domain.constant.CommonConstant;
import com.bailuntec.domain.entity.DcBaseCostFirst;
import com.bailuntec.domain.entity.DcMidCostFirst;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.DcMidCostFirstExample;
import com.bailuntec.mapper.DcBaseCostFirstMapper;
import com.bailuntec.mapper.DcMidCostFirstMapper;
import com.bailuntec.mapper.JobPointLogMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;

import java.math.BigDecimal;
import java.util.List;

public class CalculateCostFirstJob extends PointJob {

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
        boolean haseNextPage = true;
        do {
            try {
                DcBaseCostFirstMapper dcBaseCostFirstMapper = SessionUtil.getSession().getMapper(DcBaseCostFirstMapper.class);
                DcMidCostFirstMapper dcMidCostFirstMapper = SessionUtil.getSession().getMapper(DcMidCostFirstMapper.class);
                List<DcBaseCostFirst> dcBaseCostFirsts = dcBaseCostFirstMapper.listSkuWarehouseCostFirst((jobPointLog.getPageIndex() - 1) * jobPointLog.getPageSize(), jobPointLog.getPageSize());
                if (dcBaseCostFirsts != null && dcBaseCostFirsts.size() > 0) {
                    for (DcBaseCostFirst dcBaseCostFirst : dcBaseCostFirsts) {
                        BigDecimal unitSkuCostFirst = dcBaseCostFirst.getCostFirst().divide(BigDecimal.valueOf(dcBaseCostFirst.getQuantity()), 3, BigDecimal.ROUND_HALF_EVEN);
                        DcMidCostFirst dcMidCostFirst = new DcMidCostFirst();
                        dcMidCostFirst.setBailunSku(dcBaseCostFirst.getBailunSku());
                        dcMidCostFirst.setWarehouseCode(dcBaseCostFirst.getWarehouseCode());
                        dcMidCostFirst.setCostFirst(unitSkuCostFirst.divide(CommonConstant.BIGDECIMAL_TWO));
                        int i = dcMidCostFirstMapper.updateByExampleSelective(dcMidCostFirst, DcMidCostFirstExample.newAndCreateCriteria().andBailunSkuEqualTo(dcMidCostFirst.getBailunSku()).andWarehouseCodeEqualTo(dcMidCostFirst.getWarehouseCode()).example());
                        if (i == 0) {
                            dcMidCostFirstMapper.insertSelective(dcMidCostFirst);
                        }
                    }
                } else {
                    haseNextPage = false;
                }
                if (jobPointLog.getPageIndex() % 8 == 0) {
                    JobPointLogMapper mapper = SessionUtil.getSession().getMapper(JobPointLogMapper.class);
                    mapper.upsertSelective(jobPointLog);
                }
            } catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("MYBATIS操作DB失败", e);
            } finally {
                SessionUtil.closeSession();
            }
            jobPointLog.setPageIndex(jobPointLog.getPageIndex() + 1);
        } while (haseNextPage);
        jobPointLog.setPageIndex(1);
    }
}
