package com.bailuntec.job;


import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.mapper.DcMidTransitMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;

public class DailyTransitJob extends PointJob {
    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
        try {
            DcMidTransitMapper mapper = SessionUtil.getSession().getMapper(DcMidTransitMapper.class);
            mapper.insertMidDailyTransit();
            mapper.updateSkuUnitPrice();
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("MYBATIS操作DB失败",e);
        } finally {
            SessionUtil.closeSession();
        }
    }
}
