package com.bailuntec.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtil {
    /**
     * zip解压
     * @param srcFilePath     zip源文件路径
     * @param destDirPath     解压到的目标文件夹
     * @throws RuntimeException 解压失败会抛出运行时异常
     */
    public static void unZip(String srcFilePath, String destDirPath) throws RuntimeException {
        File srcFile = new File(srcFilePath);
        File destDir = new File(destDirPath);
        if (!srcFile.exists()) {
            throw new RuntimeException(srcFile.getPath() + "所指文件不存在");
        }
        if (!destDir.exists()){
            destDir.mkdirs();
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(srcFile, Charset.forName("GBK"));
            Enumeration<?> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry) entries.nextElement();
                if (entry.isDirectory()) {
                    String dirPath = destDirPath + "/" + entry.getName();
                    File dir = new File(dirPath);
                    dir.mkdirs();
                } else {
                    String targetFilePath = destDirPath + "/" + entry.getName();
                    InputStream is = zipFile.getInputStream(entry);
                    writeFileToDisk(targetFilePath, is);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("解压文件发生错误", e);
        } finally {
            if(zipFile != null){
                try {
                    zipFile.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void writeFileToDisk(String targetFilePath, InputStream is) throws Exception{
        File targetFile = new File(targetFilePath);
        if(!targetFile.getParentFile().exists()){
            targetFile.getParentFile().mkdirs();
        }
        targetFile.createNewFile();
        FileOutputStream fos = new FileOutputStream(targetFile);
        int len;
        byte[] buf = new byte[2048];
        while ((len = is.read(buf)) != -1) {
            fos.write(buf, 0, len);
        }
        fos.close();
        is.close();
    }

    /**
     * 获取特定文件夹下所有文件夹或文件的名称
     * @param dirPath
     * @return
     */
    public static List<String> getFileNameList(String dirPath) {
        List<String> nameList = new ArrayList<>();
        File file = new File(dirPath);
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; i++) {
                nameList.add(files[i].getPath());
            }
        } else {
            throw new RuntimeException(file.getPath() + "所指文件夹不存在");
        }
        return nameList;
    }

    /**
     * 删除文件或文件夹
     * @param fileOrDirPath
     */
    public static void delFile(String fileOrDirPath) {
        File file = new File(fileOrDirPath);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            List<String> filePathList = getFileNameList(fileOrDirPath);
            if (filePathList.size() > 0){
                for (String filePath : filePathList){
                    delFile(filePath);
                }
            }
        }
        file.delete();
    }
}
