package com.bailuntec.domain.enumerate;

public enum AccountPlatformType {

    Amazon(15, "AMAZON"),
    Wish(8, "WISH"),
    Cdiscount(10, "CDISCOUNT"),
    Ebay(12, "EBAY"),
    Shopee(69, "SHOPEE"),
    Browze(103, "BROWZE"),
    Bonanza(104, "BONANZA"),
    Ebid(105, "EBID"),
    Eiigoo(106, "EIIGOO"),
    Stardaymart(107, "STARDAYMART"),
    Walmart(62, "WALMART"),
    Aliexpress(4, "ALIEXPRESS");

    private final int code;
    private final String value;

    AccountPlatformType(int code, String value) {
        this.code = code;
        this.value = value;
    }

    public String value() {
        return value;
    }

    public int code() {
        return code;
    }

    public static class Shopify {
        public static Integer code() {
            return 1;
        }
    }
}
