package com.bailuntec.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bailuntec.domain.entity.DcBaseCompanyAccount;
import com.bailuntec.domain.entity.DcBaseFinanceAmazonAdProduct;
import com.bailuntec.domain.entity.JobAmazonAdLog;
import com.bailuntec.domain.enumerate.CurrencyType;
import com.bailuntec.domain.example.DcBaseCompanyAccountExample;
import com.bailuntec.domain.example.DcBaseFinanceAmazonAdProductExample;
import com.bailuntec.domain.example.JobAmazonAdLogExample;
import com.bailuntec.domain.pojo.AmazonAdAuth;
import com.bailuntec.domain.pojo.AmazonAdProduct;
import com.bailuntec.mapper.DcBaseCompanyAccountMapper;
import com.bailuntec.mapper.DcBaseFinanceAmazonAdProductMapper;
import com.bailuntec.mapper.JobAmazonAdLogMapper;
import com.bailuntec.support.CallBailunSystem;
import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.api.simple.SimpleJob;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.beanutils.BeanUtils;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.zip.GZIPInputStream;

@Slf4j
public class AmazonAdDownloadReportJob implements SimpleJob {
    private final OkHttpClient client = OkHttpUtil.getInstance();

    @Override
    public void execute(ShardingContext shardingContext) {
        /**
         * 根据分片数去拿
         * job_amazon_ad_log
         * 中未下载
         * 15分钟前
         * 的reportId
         */
        int totalPage = countJobAmazonAdLog();
        int pageSize = totalPage % shardingContext.getShardingTotalCount() == 0 ? totalPage / shardingContext.getShardingTotalCount() : totalPage / shardingContext.getShardingTotalCount() + 1;
        if (totalPage > 0) {
            List<JobAmazonAdLog> jobAmazonAdLogList = findJobAmazonAdLogList(shardingContext, pageSize);
            String shardParam = shardingContext.getJobParameter();
            if (jobAmazonAdLogList != null && !jobAmazonAdLogList.isEmpty()) {
                for (JobAmazonAdLog jobAmazonAdLog : jobAmazonAdLogList) {
                    downloadReport(jobAmazonAdLog, shardParam);
                }
            }
        }
    }

    private void handleReport(JobAmazonAdLog jobAmazonAdLog, AmazonAdAuth amazonAdAuth, String shardParam) {
        Response response = null;
        GZIPInputStream gzin = null;
        Request request = new Request.Builder()
                .url(AmazonAdGenerateReportIdJob.switchSiteUrl(jobAmazonAdLog.getSiteEn(), jobAmazonAdLog.getReportId()))
                .get()
                .addHeader("Authorization", amazonAdAuth.getAccessToken())
                .addHeader("Amazon-Advertising-API-ClientId", amazonAdAuth.getClientId())
                .addHeader("Amazon-Advertising-API-Scope", amazonAdAuth.getProfileId())
                .addHeader("Content-Type", "application/json")
                .build();
        for (int i = 0; i < 3; i++) {
            try {
                response = client.newCall(request).execute();
                if (response.isSuccessful()) {
                    gzin = new GZIPInputStream(response.body().byteStream());
                    log.warn("开始解析账号Id为" + jobAmazonAdLog.getAccountId() +"的Report----" + jobAmazonAdLog.getReportId() + ", 文件大小为" +response.body().contentLength());
                    List<AmazonAdProduct> amazonAdProductList = JSON.parseObject(gzin, new TypeReference<List<AmazonAdProduct>>() {
                    }.getType());
                    log.warn("账号Id"+ jobAmazonAdLog.getAccountId() +"的Report解析完成");
                    gzin.close();
                    response.close();
                    JobAmazonAdLogMapper jobAmazonAdLogMapper = SessionUtil.getSession().getMapper(JobAmazonAdLogMapper.class);
                    LocalDateTime startTime = LocalDateTime.now();
                    if (amazonAdProductList != null && amazonAdProductList.size() > 0) {
                        DcBaseFinanceAmazonAdProductMapper mapper = SessionUtil.getSession().getMapper(DcBaseFinanceAmazonAdProductMapper.class);
                        DcBaseFinanceAmazonAdProduct dcBaseFinanceAmazonAdProduct = new DcBaseFinanceAmazonAdProduct();
                        for (AmazonAdProduct amazonAdvert : amazonAdProductList) {
                            if (BigDecimal.ZERO.compareTo(amazonAdvert.getCost()) != 0) {
                                BeanUtils.copyProperties(dcBaseFinanceAmazonAdProduct, amazonAdvert);
                                dcBaseFinanceAmazonAdProduct.setAccountId(jobAmazonAdLog.getAccountId());
                                dcBaseFinanceAmazonAdProduct.setCompanyId(jobAmazonAdLog.getCompanyId());
                                dcBaseFinanceAmazonAdProduct.setReportDate(jobAmazonAdLog.getReportDate());
                                dcBaseFinanceAmazonAdProduct.setExchangeRate(CallBailunSystem.getExchangeRate(dcBaseFinanceAmazonAdProduct.getCurrency(), CurrencyType.CNY.value(), jobAmazonAdLog.getReportDate().atStartOfDay()));
                                dcBaseFinanceAmazonAdProduct.setExchangeRateUsd(CallBailunSystem.getExchangeRate(dcBaseFinanceAmazonAdProduct.getCurrency(), CurrencyType.USD.value(), jobAmazonAdLog.getReportDate().atStartOfDay()));
                                dcBaseFinanceAmazonAdProduct.setBjModifyTime(LocalDateTime.now());
                                DcBaseFinanceAmazonAdProductExample example = DcBaseFinanceAmazonAdProductExample.newAndCreateCriteria().andCompanyIdEqualTo(dcBaseFinanceAmazonAdProduct.getCompanyId()).andAccountIdEqualTo(dcBaseFinanceAmazonAdProduct.getAccountId()).andCampaignIdEqualTo(dcBaseFinanceAmazonAdProduct.getCampaignId()).andAdGroupIdEqualTo(dcBaseFinanceAmazonAdProduct.getAdGroupId()).andSkuEqualTo(dcBaseFinanceAmazonAdProduct.getSku()).andReportDateEqualTo(dcBaseFinanceAmazonAdProduct.getReportDate()).example();
                                int update = mapper.updateByExampleSelective(dcBaseFinanceAmazonAdProduct, example, shardParam);
                                if (update == 0) {
                                    mapper.insertSelective(dcBaseFinanceAmazonAdProduct, shardParam);
                                }
                            }
                        }
                    }
                    DcBaseFinanceAmazonAdProductMapper mapper = SessionUtil.getSession().getMapper(DcBaseFinanceAmazonAdProductMapper.class);
                    mapper.deleteByExample(DcBaseFinanceAmazonAdProductExample.newAndCreateCriteria().andAccountIdEqualTo(jobAmazonAdLog.getAccountId()).andCompanyIdEqualTo(jobAmazonAdLog.getCompanyId()).andReportDateEqualTo(jobAmazonAdLog.getReportDate()).andBjModifyTimeLessThan(startTime.minusHours(1)).example());
                    jobAmazonAdLog.setStatus(true);
                    jobAmazonAdLogMapper.updateByExampleSelective(jobAmazonAdLog, JobAmazonAdLogExample.newAndCreateCriteria().andCompanyIdEqualTo(jobAmazonAdLog.getCompanyId()).andAccountIdEqualTo(jobAmazonAdLog.getAccountId()).andReportDateEqualTo(jobAmazonAdLog.getReportDate()).example());
                    break;
                } else {
                    String s = response.body().string();
                    log.warn("账号Id"+ jobAmazonAdLog.getAccountId()+"，第" + i+"次下载报告不成功: " + s);
                }
            } catch (Exception e) {
                e.printStackTrace();
                log.error("账号Id"+ jobAmazonAdLog.getAccountId()+"，第" + i+"次调用获取AmazonADReportLocation错误:", e);
            } finally {
                SessionUtil.closeSession();
                if (gzin != null) {
                    try {
                        gzin.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                        log.error("gzin关闭错误:", e);
                    }
                }
                if (response != null) {
                    response.close();
                }
            }
        }
    }

    private void downloadReport(JobAmazonAdLog jobAmazonAdLog, String shardParam) {
        DcBaseCompanyAccount dcBaseCompanyAccount = getToken(jobAmazonAdLog);
        AmazonAdAuth amazonAdAuth = JSON.parseObject(dcBaseCompanyAccount.getAmazonAdAuthJson(), AmazonAdAuth.class);
        handleReport(jobAmazonAdLog, amazonAdAuth, shardParam);
    }

    private DcBaseCompanyAccount getToken(JobAmazonAdLog jobAmazonAdLog) {
        DcBaseCompanyAccountMapper mapper = SessionUtil.getSession().getMapper(DcBaseCompanyAccountMapper.class);
        return mapper.selectOneByExample(DcBaseCompanyAccountExample.newAndCreateCriteria().andCompanyIdEqualTo(jobAmazonAdLog.getCompanyId()).andAccountIdEqualTo(jobAmazonAdLog.getAccountId()).example());
    }


    private List<JobAmazonAdLog> findJobAmazonAdLogList(ShardingContext shardingContext, int pageSize) {
        try {
            JobAmazonAdLogMapper mapper = SessionUtil.getSession().getMapper(JobAmazonAdLogMapper.class);
            return mapper.selectByExample(JobAmazonAdLogExample.newAndCreateCriteria().andStatusEqualTo(false).andBjModifiedLessThan(LocalDateTime.now().minusMinutes(15)).example().orderBy("id").limit(shardingContext.getShardingItem() * pageSize, pageSize));
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        } finally {
            SessionUtil.closeSession();
        }
    }

    private int countJobAmazonAdLog() {
        try {
            JobAmazonAdLogMapper mapper = SessionUtil.getSession().getMapper(JobAmazonAdLogMapper.class);
            return (int) mapper.countByExample(JobAmazonAdLogExample.newAndCreateCriteria().andStatusEqualTo(false).example());
        } catch (Exception e) {
            e.printStackTrace();
            return 0;
        } finally {
            SessionUtil.closeSession();
        }

    }
}
