package com.bailuntec.controller;

import com.alibaba.fastjson.JSONObject;
import com.bailuntec.domain.entity.BaseStockVO;
import com.bailuntec.domain.entity.DcBaseStock;
import com.bailuntec.domain.pojo.ResponseResult;
import com.bailuntec.service.InventoryService;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.List;

@RestController
public class InventoryController {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private InventoryService inventoryService;

    /**
     * 对外提供库存查询接口
     * 数据来源dc_base_stock表
     * skus
     */
    @RequestMapping("/stock")
    public ResponseResult listStockInfo(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        try {
            List<BaseStockVO> listInventoryInfo = inventoryService.listStockInfo(jsonObject);
            return new ResponseResult<>(LocalDateTime.now(), HttpStatus.OK.value(), null, null, request.getServletPath(), listInventoryInfo);
        } catch (Exception e) {
            log.error("获取库存信息错误" + jsonObject.toJSONString(), e);
            return new ResponseResult(LocalDateTime.now(), HttpStatus.BAD_REQUEST.value(), e.getMessage(), null, request.getServletPath(), null);
        }
    }

    /**
     * pageIndex
     * pageSize
     * startTime
     * endTime
     * @param jsonObject
     * @param request
     * @return
     */
    @RequestMapping("/baseStock")
    public ResponseResult listBaseStockInfo(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        try {
            PageInfo<DcBaseStock> listInventoryInfo = inventoryService.listBaseStockInfo(jsonObject);
            return new ResponseResult<>(LocalDateTime.now(), HttpStatus.OK.value(), null, null, request.getServletPath(), listInventoryInfo);
        } catch (Exception e) {
            log.error("获取库存信息错误" + jsonObject.toJSONString(), e);
            return new ResponseResult(LocalDateTime.now(), HttpStatus.BAD_REQUEST.value(), e.getMessage(), null, request.getServletPath(), null);
        }
    }


}
