package com.bailuntec.controller;

import com.bailuntec.service.AccountingEntryService;
import com.bailuntec.util.ResponseUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/aliexpress")
public class AccountingEntryController {

    @Autowired
    private AccountingEntryService accountingEntryService;

    @PostMapping("/uploadZipFile")
    public Map<String, Object> uploadZipFile(@RequestParam("platform") String platform,@RequestParam MultipartFile zipFile) {
        try {
            accountingEntryService.uploadToQiniu(platform, zipFile);
            return ResponseUtil.success();
        } catch (Exception e){
            log.warn("",e);
            return ResponseUtil.failed(e.getCause().toString());
        }
    }
}
