package com.bailuntec.job;

import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.mapper.DcBaseFinanceFeeMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;

import java.time.LocalDate;

public class DailyFeeJob extends PointJob {

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
        DcBaseFinanceFeeMapper dcBaseFinanceFeeMapper = SessionUtil.getSession().getMapper(DcBaseFinanceFeeMapper.class);
        try
        {
            dcBaseFinanceFeeMapper.deleteDailyFee(LocalDate.now().minusDays(1L));
            dcBaseFinanceFeeMapper.insertDailyFee(LocalDate.now().minusDays(1L));
        }
        catch (Exception ex)
        {

        }

    }
}
