package com.bailuntec.serviceImpl;

import com.bailuntec.domain.entity.DcBaseSku;
import com.bailuntec.domain.entity.DcDailySales;
import com.bailuntec.domain.pojo.DcDailySalesVO;
import com.bailuntec.mapper.BaseSkuMapper;
import com.bailuntec.mapper.DcDailySalesMapper;
import com.bailuntec.service.SalesService;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.util.StringUtil;

import java.util.List;
@Service
public class SalesServiceImpl implements SalesService {
    @Autowired
    private DcDailySalesMapper dailySalesMapper;

    @Override
    public PageInfo<DcDailySalesVO> listSkus(String skus) {
        List<DcDailySalesVO> dcBaseSkus = null;
        PageInfo<DcDailySalesVO> pageInfo = null;
        if (StringUtil.isNotEmpty(skus)) {
            dcBaseSkus = dailySalesMapper.listSkuInfo(skus.split(","));
            pageInfo = PageInfo.of(dcBaseSkus);
        }
        return pageInfo;
    }
}
