package com.bailuntec.domain.entity;

import lombok.AllArgsConstructor;

import javax.persistence.*;
import java.time.LocalDateTime;
import java.util.Objects;


@AllArgsConstructor
@Entity
@Table(name = "dc_accounting_entry_task", schema = "bailun_datacenter", catalog = "")
public class DcAccountingEntryTask {
    private int id;
    private int userId;
    private String zipFilePath;
    private int executeStatus;
    private String errorMessage;
    private LocalDateTime createTime;
    private LocalDateTime updateTime;

    @Id
    @Column(name = "id")
    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Basic
    @Column(name = "user_id")
    public int getUserId() {
        return userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    @Basic
    @Column(name = "zip_file_path")
    public String getZipFilePath() {
        return zipFilePath;
    }

    public void setZipFilePath(String zipFilePath) {
        this.zipFilePath = zipFilePath;
    }

    @Basic
    @Column(name = "execute_status")
    public int getExecuteStatus() {
        return executeStatus;
    }

    public void setExecuteStatus(int executeStatus) {
        this.executeStatus = executeStatus;
    }

    @Basic
    @Column(name = "error_message")
    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Basic
    @Column(name = "create_time")
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    @Basic
    @Column(name = "update_time")
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DcAccountingEntryTask that = (DcAccountingEntryTask) o;
        return id == that.id &&
                userId == that.userId &&
                executeStatus == that.executeStatus &&
                Objects.equals(zipFilePath, that.zipFilePath) &&
                Objects.equals(errorMessage, that.errorMessage) &&
                Objects.equals(createTime, that.createTime) &&
                Objects.equals(updateTime, that.updateTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, userId, zipFilePath, executeStatus, errorMessage, createTime, updateTime);
    }
}
