package com.bailuntec.controller;

import com.alibaba.fastjson.JSON;
import com.bailuntec.domain.pojo.ResponseResult;
import com.bailuntec.service.StorageFeeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.List;

@RestController
@RequestMapping("/fee")
public class StorageFeeController {
    @Autowired
    private StorageFeeService storageFeeService;
    private Logger log = LoggerFactory.getLogger(StorageFeeController.class);
    @RequestMapping(value = "/storage/upload", method = RequestMethod.POST)
    public String storageUpload(@RequestParam("file") MultipartFile file, HttpServletRequest request){
        try {
            if (file != null && !file.isEmpty()) {
                storageFeeService.analyzeFile(file, request);
            } else {
                return JSON.toJSONString(new ResponseResult(LocalDateTime.now(), HttpStatus.MULTIPLE_CHOICES.value(), "WARN", "参数错误或文件为空", request.getServletPath()));
            }
            return JSON.toJSONString(new ResponseResult(LocalDateTime.now(), HttpStatus.OK.value(), "SUCCESS", "文件处理成功", request.getServletPath()));
        } catch (Exception e) {
            log.error("读取仓储费文件错误" + file.getOriginalFilename(), e);
            return JSON.toJSONString(new ResponseResult(LocalDateTime.now(), HttpStatus.BAD_REQUEST.value(), "EXCEPTION", "文件处理失败", request.getServletPath()));
        }
    }

    @RequestMapping(value = "/storage/uploads", method = RequestMethod.POST)
    public String storageUploads(@RequestParam(value = "files", required = true) List<MultipartFile> files, HttpServletRequest request) {
        try {
            if (files != null && files.size() > 0) {
                for (MultipartFile file : files) {
                    storageFeeService.analyzeFile(file,request);
                }
                files = null;
            } else {
                return JSON.toJSONString(new ResponseResult(LocalDateTime.now(), HttpStatus.MULTIPLE_CHOICES.value(), "WARN", "参数错误或文件为空", request.getServletPath()));
            }
            return JSON.toJSONString(new ResponseResult(LocalDateTime.now(), HttpStatus.OK.value(), "SUCCESS", "文件处理成功", request.getServletPath()));
        } catch (Exception e) {
            log.error("批量读取仓储费文件错误", e);
            return JSON.toJSONString(new ResponseResult(LocalDateTime.now(), HttpStatus.BAD_REQUEST.value(), "EXCEPTION", "文件处理失败", request.getServletPath()));
        }
    }

    @RequestMapping(value = "/long-term-storage/upload", method = RequestMethod.POST)
    public String longTermStorageUpload(@RequestParam("file") MultipartFile file, HttpServletRequest request){
        try {
            if (file != null && !file.isEmpty()) {
                storageFeeService.analyzeLongTermStorageFile(file, request);
            } else {
                return JSON.toJSONString(new ResponseResult(LocalDateTime.now(), HttpStatus.MULTIPLE_CHOICES.value(), "WARN", "参数错误或文件为空", request.getServletPath()));
            }
            return JSON.toJSONString(new ResponseResult(LocalDateTime.now(), HttpStatus.OK.value(), "SUCCESS", "文件处理成功", request.getServletPath()));
        } catch (Exception e) {
            log.error("读取长期仓储费文件错误" + file.getOriginalFilename(), e);
            return JSON.toJSONString(new ResponseResult(LocalDateTime.now(), HttpStatus.BAD_REQUEST.value(), "EXCEPTION", "文件处理失败", request.getServletPath()));
        }
    }

    @RequestMapping(value = "/long-term-storage/uploads", method = RequestMethod.POST)
    public String longTermStorageuploads(@RequestParam(value = "files", required = true) List<MultipartFile> files, HttpServletRequest request) {
        try {
            if (files != null && files.size() > 0) {
                for (MultipartFile file : files) {
                    storageFeeService.analyzeLongTermStorageFile(file,request);
                }
                files = null;
            } else {
                return JSON.toJSONString(new ResponseResult(LocalDateTime.now(), HttpStatus.MULTIPLE_CHOICES.value(), "WARN", "参数错误或文件为空", request.getServletPath()));
            }
            return JSON.toJSONString(new ResponseResult(LocalDateTime.now(), HttpStatus.OK.value(), "SUCCESS", "文件处理成功", request.getServletPath()));
        } catch (Exception e) {
            log.error("批量读取长期仓储费文件错误", e);
            return JSON.toJSONString(new ResponseResult(LocalDateTime.now(), HttpStatus.BAD_REQUEST.value(), "EXCEPTION", "文件处理失败", request.getServletPath()));
        }
    }
}
