package com.bailuntec.balancesheet.mapper;

import com.bailuntec.balancesheet.dto.BankAccountBalanceDTO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Repository
public interface DcBankAccountBalanceMapper {
    @Insert("<script>" +
            "insert into dc_bank_account_balance(company_value,company_name,pay_account_id,bank_name,bank_card,bank_card_user,balance_rmb,statistical_time) values " +
            "<foreach collection='list' item='item' index='index' separator=','>" +
            "(#{item.companyValue},#{item.companyName},#{item.payAccountId},#{item.bankName},#{item.bankCard},#{item.bankCardUser},#{item.balanceRmb},#{lastDay})" +
            "</foreach>" +
            "on duplicate key update company_value=values(company_value),company_name=values(company_name),bank_name=values(bank_name)," +
            "bank_card=values(bank_card),bank_card_user=values(bank_card_user),balance=values(balance_rmb),statistical_time = values(statistical_time)"+
            "</script>")
    void insertOrUpdateBankAccountBalance(@Param("list") List<BankAccountBalanceDTO> bankAccountBalanceDTOList, @Param("lastDay") Date lastDay);

    @Insert("<script>" +
            "insert into dc_bank_account_balance(company_value,company_name,pay_account_id,bank_name,bank_card,bank_card_user,balance_rmb,statistical_time) values " +
            "<foreach collection='list' item='item' index='index' separator=','>" +
            "(#{item.companyValue},#{item.companyName},#{item.payAccountId},#{item.bankName},#{item.bankCard},#{item.bankCardUser},#{item.balanceRmb},#{lastDay})" +
            "</foreach>" +
            "</script>")
    void insertBankAccountBalance(@Param("list") List<BankAccountBalanceDTO> bankAccountBalanceDTOList, @Param("lastDay") Date lastDay);

    @Delete("delete b from dc_bank_account_balance b inner join dc_company_main_body c on b.company_value = c.company_value and c.no_monetary_fund = 1 " +
            "where b.statistical_time = #{lastDay}")
    void deleteUnusedData(@Param("lastDay") Date lastDay);

    @Delete("delete from dc_bank_account_balance where company_value = 2 and bank_name in ('paypal','payoneer') and statistical_time = #{lastDay}")
    void deleteUnusedData1(@Param("lastDay") Date lastDay);

    @Delete("delete from dc_bank_account_balance where company_value = 0 and statistical_time = #{lastDay}")
    void deleteUnusedData2(@Param("lastDay") Date lastDay);

    @Select("select sum(balance_rmb) from dc_bank_account_balance where statistical_time = #{lastDay}")
    BigDecimal getBalanceSum(@Param("lastDay") Date lastDay);

}
