package com.bailuntec.job;

import com.bailuntec.domain.entity.DcBaseCrmRefund;
import com.bailuntec.domain.entity.DcBaseOmsOrder;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.domain.example.DcBaseCrmRefundExample;
import com.bailuntec.domain.example.DcBaseOmsOrderExample;
import com.bailuntec.mapper.DcBaseCrmRefundMapper;
import com.bailuntec.mapper.DcBaseOmsOrderMapper;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import lombok.extern.slf4j.Slf4j;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

@Slf4j
public class CrmStatusSyncJob extends PointJob {

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM");
        LocalDate localDate1 = LocalDate.now();
        String localDateStr = fmt.format(localDate1);
        long count = count(localDateStr);
        long totalPage = count % jobPointLog.getPageSize() == 0 ? count/jobPointLog.getPageSize() : count/jobPointLog.getPageSize() + 1 ;
        do{
            DcBaseCrmRefundMapper dcBaseCrmRefundMapper = SessionUtil.getSession().getMapper(DcBaseCrmRefundMapper.class);
            List<DcBaseCrmRefund> dcBaseCrmRefundList = dcBaseCrmRefundMapper.selectByRefundDate(localDateStr, jobPointLog.getPageIndex()*jobPointLog.getPageSize(), jobPointLog.getPageSize());
            try {
                for (DcBaseCrmRefund dcBaseCrmRefund : dcBaseCrmRefundList) {
                    DcBaseOmsOrderMapper omsOrderMapper = SessionUtil.getSession().getMapper(DcBaseOmsOrderMapper.class);
                    DcBaseOmsOrder dcBaseOmsOrder = null;

                    if(dcBaseCrmRefund.getPlatformType() != null) {
                        switch (dcBaseCrmRefund.getPlatformType().toUpperCase()) {
                            case "EBAY":
                                dcBaseOmsOrder = omsOrderMapper.selectOneByExample(DcBaseOmsOrderExample.newAndCreateCriteria().andBailunAccountIdEqualTo(dcBaseCrmRefund.getBailunAccountId()).andTransactionIdEqualTo(dcBaseCrmRefund.getOriginOrderId()).example());
                                break;
                            default:
                                dcBaseOmsOrder = omsOrderMapper.selectOneByExample(DcBaseOmsOrderExample.newAndCreateCriteria().andBailunAccountIdEqualTo(dcBaseCrmRefund.getBailunAccountId()).andOriginOrderIdEqualTo(dcBaseCrmRefund.getOriginOrderId()).example());
                        }

                        if(dcBaseOmsOrder != null) {
                            if("MERGED".equals(dcBaseOmsOrder.getBailunMergeStatus().toUpperCase())) {
                                dcBaseOmsOrder = omsOrderMapper.selectOneByExample(DcBaseOmsOrderExample.newAndCreateCriteria().andBailunAccountIdEqualTo(dcBaseCrmRefund.getBailunAccountId()).andOriginOrderIdEqualTo(dcBaseOmsOrder.getAftermergedBailunOrderNo()).example());
                            }
                            if(dcBaseOmsOrder != null) {
                                dcBaseCrmRefund.setOrderStatus(dcBaseOmsOrder.getBailunOrderStatus());
                                dcBaseCrmRefund.setShippingStatus(dcBaseOmsOrder.getBailunShippingStatus());
                                if("FBA".equals(dcBaseCrmRefund.getPlatformType().toUpperCase())) {
                                    dcBaseCrmRefund.setShippingStatus("TotalShipping");
                                }
                            }
                        }
                    }
                    DcBaseCrmRefundMapper mapper = SessionUtil.getSession().getMapper(DcBaseCrmRefundMapper.class);
                    int i = mapper.updateByExampleSelective(dcBaseCrmRefund, DcBaseCrmRefundExample.newAndCreateCriteria().andCrmIdEqualTo(dcBaseCrmRefund.getCrmId()).example());
                    if (i == 0) {
                        mapper.insertSelective(dcBaseCrmRefund);
                    }
                }
                jobPointLog.setPageIndex(jobPointLog.getPageIndex() + 1);
            } catch (Exception e) {
                throw new RuntimeException("MYBATIS操作DB异常", e);
            } finally {
                SessionUtil.closeSession();
            }
        }while (jobPointLog.getPageIndex() < totalPage);
            jobPointLog.setPageIndex(0);
            jobPointLog.setGmtModified(LocalDateTime.now());
    }

    public long count(String localDateStr) {
        long count = 0;
        try{
            DcBaseCrmRefundMapper dcBaseCrmRefundMapper = SessionUtil.getSession().getMapper(DcBaseCrmRefundMapper.class);
            count = dcBaseCrmRefundMapper.countByDate(localDateStr);
        }catch (Exception e){
            throw new RuntimeException("MYBATIS操作DB异常", e);
        }finally {
            SessionUtil.closeSession();
        }
        return count;
    }
}
