package com.bailuntec.controller;

import com.alibaba.fastjson.JSONObject;
import com.bailuntec.domain.entity.DcBaseSku;
import com.bailuntec.domain.pojo.ResponseResult;
import com.bailuntec.service.SkuService;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;

@RestController
public class SkuController {
    @Autowired
    private SkuService skuService;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    /**
     * 对外提供SKU信息接口
     * pageIndex
     * pageSize
     * startTime
     * endTime
     */
    @RequestMapping("/sku")
    public ResponseResult listSkuInfo(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        try {
            PageInfo<DcBaseSku> dcSkuListInfo = skuService.listSku(jsonObject);
            return new ResponseResult<>(LocalDateTime.now(), HttpStatus.OK.value(), null, null, request.getServletPath(), dcSkuListInfo);
        } catch (Exception e) {
            log.error("获取SKU信息错误" + jsonObject, e);
            return new ResponseResult(LocalDateTime.now(), HttpStatus.BAD_REQUEST.value(), e.getMessage(), null, request.getServletPath(), null);
        }
    }

    /**
     * 对外提供SKU信息接口
     *  skus
     */
    @RequestMapping("/skus")
    public ResponseResult listSkus(String skus, HttpServletRequest request) {
        try {
            PageInfo<DcBaseSku> dcSkuListInfo = skuService.listSkus(skus);
            return new ResponseResult<>(LocalDateTime.now(), HttpStatus.OK.value(), null, null, request.getServletPath(), dcSkuListInfo);
        } catch (Exception e) {
            log.error("获取SKU信息错误" + skus, e);
            return new ResponseResult(LocalDateTime.now(), HttpStatus.BAD_REQUEST.value(), e.getMessage(), null, request.getServletPath(), null);
        }
    }
}
