package com.bailuntec.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bailuntec.domain.FinanceSalesplatformInfo;
import com.bailuntec.domain.WithdrawInfo;
import com.bailuntec.domain.constant.CommonConstant;
import com.bailuntec.domain.entity.DcBaseFinanceCashierdetail;
import com.bailuntec.domain.entity.DcBaseFinanceSalesplatform;
import com.bailuntec.domain.entity.JobPointLog;
import com.bailuntec.mapper.DcBaseFinanceCashierdetailMapper;
import com.bailuntec.mapper.DcBaseFinanceSalesplatformMapper;
import com.bailuntec.support.CallBailunSystem;
import com.bailuntec.support.PointJob;
import com.bailuntec.utils.OkHttpUtil;
import com.bailuntec.utils.PropertiesUtil;
import com.bailuntec.utils.SessionUtil;
import com.dangdang.ddframe.job.api.ShardingContext;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;

@Slf4j
public class SalesPlatformJob extends PointJob {


    private OkHttpClient okHttpClient = OkHttpUtil.getInstance();
    private PropertiesUtil propertiesUtil = PropertiesUtil.getInstance("const");

    @Override
    public void executeJob(ShardingContext shardingContext, JobPointLog jobPointLog) {
            Response response = null;
            String palResultStr = null;
            try {
                Request request = new Request.Builder()
                        .get()
                        .url(propertiesUtil.getPropertyAsString("SALES_PLATFORM"))
                        .addHeader("Content-Type", "application/json")
                        .build();
                response = okHttpClient.newCall(request).execute();
                palResultStr = response.body().string();
            } catch (IOException e) {
                throw new RuntimeException("请求销售平台同步百伦接口失败" + response, e);
            } finally {
                if (response != null) {
                    response.close();
                }
            }
            if (StringUtils.isNoneBlank(palResultStr)) {
                List<FinanceSalesplatformInfo> salesplatformInfos = JSON.parseObject(palResultStr, new TypeReference<List<FinanceSalesplatformInfo>>() {
                });
                if (salesplatformInfos != null && salesplatformInfos.size() > 0) {
                    for(FinanceSalesplatformInfo financeSalesplatformInfo : salesplatformInfos) {
                        try {
                            DcBaseFinanceSalesplatform dcBaseFinanceSalesplatform = new DcBaseFinanceSalesplatform();
                            DcBaseFinanceSalesplatformMapper dcBaseFinanceSalesplatformMapper = SessionUtil.getSession().getMapper(DcBaseFinanceSalesplatformMapper.class);
                            BeanUtils.copyProperties(dcBaseFinanceSalesplatform, financeSalesplatformInfo);
                            dcBaseFinanceSalesplatformMapper.upsertSelective(dcBaseFinanceSalesplatform);
                        } catch (Exception e) {
                            throw new RuntimeException("Mybatis操作DB失败", e);
                        }finally {
                            SessionUtil.closeSession();
                        }
                    }
                }
            } else {
                throw new RuntimeException("调用销售平台接口同步百伦流水失败, 响应为null, 请求参数");
            }
    }
}
