package com.bailuntec.balancesheet.dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class LogisticsSupplierTransactionDTO {
    @JSONField(name = "SupplierId")
    private Integer supplierId;
    @JSONField(name = "SupplierName")
    private String supplierName;
    @JSONField(name = "PayCompanyId")
    private Integer payCompanyValue;
    @JSONField(name = "PayCompanyName")
    private String payCompanyName;
    @JSONField(name = "StartAmount")
    private BigDecimal startAmount;
    @JSONField(name = "EndAmount")
    private BigDecimal endAmount;
    @JSONField(name = "BorrowAmount")
    private BigDecimal borrowAmount;
    @JSONField(name = "LoanAmount")
    private BigDecimal loanAmount;
    @JSONField(name = "Type")
    private String type;
    @JSONField(name = "Day", format = "yyyy/MM/dd HH:mm:ss")
    private Date day;
}
